/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.commons.codec.digest.DigestUtils;

public class AttachmentId {
    private final String id;

    public static AttachmentId forPayload(byte[] payload) {
        Preconditions.checkArgument((payload != null ? 1 : 0) != 0);
        return new AttachmentId(DigestUtils.sha1Hex((byte[])payload));
    }

    public static AttachmentId from(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0);
        return new AttachmentId(id);
    }

    private AttachmentId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttachmentId) {
            AttachmentId other = (AttachmentId)obj;
            return Objects.equal((Object)this.id, (Object)other.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

