/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.james.mailbox.model.AttachmentId;

public class Attachment {
    private final byte[] bytes;
    private final AttachmentId attachmentId;
    private final String type;
    private final long size;

    public static Builder builder() {
        return new Builder();
    }

    private Attachment(byte[] bytes, AttachmentId attachmentId, String type, long size) {
        this.bytes = bytes;
        this.attachmentId = attachmentId;
        this.type = type;
        this.size = size;
    }

    public AttachmentId getAttachmentId() {
        return this.attachmentId;
    }

    public String getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attachment) {
            Attachment other = (Attachment)obj;
            return Objects.equal((Object)this.attachmentId, (Object)other.attachmentId) && Arrays.equals(this.bytes, other.bytes) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.size, (Object)other.size);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attachmentId, this.bytes, this.type, this.size});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attachmentId", (Object)this.attachmentId).add("bytes", (Object)this.bytes).add("type", (Object)this.type).add("size", this.size).toString();
    }

    public static class Builder {
        private AttachmentId attachmentId;
        private byte[] bytes;
        private String type;

        public Builder attachmentId(AttachmentId attachmentId) {
            Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
            this.attachmentId = attachmentId;
            return this;
        }

        public Builder bytes(byte[] bytes) {
            Preconditions.checkArgument((bytes != null ? 1 : 0) != 0);
            this.bytes = bytes;
            return this;
        }

        public Builder type(String type) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0);
            this.type = type;
            return this;
        }

        public Attachment build() {
            Preconditions.checkState((this.bytes != null ? 1 : 0) != 0, (Object)"'bytes' is mandatory");
            AttachmentId builtAttachmentId = this.attachmentId();
            Preconditions.checkState((builtAttachmentId != null ? 1 : 0) != 0, (Object)"'attachmentId' is mandatory");
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"'type' is mandatory");
            return new Attachment(this.bytes, builtAttachmentId, this.type, this.size());
        }

        private AttachmentId attachmentId() {
            if (this.attachmentId != null) {
                return this.attachmentId;
            }
            return AttachmentId.forPayload(this.bytes);
        }

        private long size() {
            return this.bytes.length;
        }
    }
}

