/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;

public interface MessageManager {
    public long getMessageCount(MailboxSession var1) throws MailboxException;

    public MailboxCounters getMailboxCounters(MailboxSession var1) throws MailboxException;

    @Deprecated
    public boolean isWriteable(MailboxSession var1) throws MailboxException;

    public boolean isModSeqPermanent(MailboxSession var1);

    public Iterator<MessageUid> search(SearchQuery var1, MailboxSession var2) throws MailboxException;

    public Iterator<MessageUid> expunge(MessageRange var1, MailboxSession var2) throws MailboxException;

    public Map<MessageUid, Flags> setFlags(Flags var1, FlagsUpdateMode var2, MessageRange var3, MailboxSession var4) throws MailboxException;

    public ComposedMessageId appendMessage(InputStream var1, Date var2, MailboxSession var3, boolean var4, Flags var5) throws MailboxException;

    public MessageResultIterator getMessages(MessageRange var1, MessageResult.FetchGroup var2, MailboxSession var3) throws MailboxException;

    public MailboxId getId();

    public MailboxPath getMailboxPath() throws MailboxException;

    public Flags getApplicableFlags(MailboxSession var1) throws MailboxException;

    public MetaData getMetaData(boolean var1, MailboxSession var2, MetaData.FetchGroup var3) throws MailboxException;

    public static interface MetaData {
        public List<MessageUid> getRecent();

        public long countRecent();

        public Flags getPermanentFlags();

        public long getUidValidity();

        public MessageUid getUidNext();

        public long getHighestModSeq();

        public long getMessageCount();

        public long getUnseenCount();

        public MessageUid getFirstUnseen();

        public boolean isWriteable();

        public boolean isModSeqPermanent();

        public MailboxACL getACL();

        public static enum FetchGroup {
            NO_UNSEEN,
            UNSEEN_COUNT,
            FIRST_UNSEEN,
            NO_COUNT;

        }
    }

    public static enum FlagsUpdateMode {
        ADD,
        REMOVE,
        REPLACE;

    }
}

