/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.base.Optional;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.MailboxListenerSupport;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.exception.AnnotationException;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MailboxQuery;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.slf4j.Logger;

public interface MailboxManager
extends RequestAware,
MailboxListenerSupport {
    public EnumSet<MailboxCapabilities> getSupportedMailboxCapabilities();

    public boolean hasCapability(MailboxCapabilities var1);

    public EnumSet<MessageCapabilities> getSupportedMessageCapabilities();

    public EnumSet<SearchCapabilities> getSupportedSearchCapabilities();

    public char getDelimiter();

    public MessageManager getMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public MessageManager getMailbox(MailboxId var1, MailboxSession var2) throws MailboxException;

    public Optional<MailboxId> createMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public void deleteMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public void renameMailbox(MailboxPath var1, MailboxPath var2, MailboxSession var3) throws MailboxException;

    public List<MessageRange> copyMessages(MessageRange var1, MailboxPath var2, MailboxPath var3, MailboxSession var4) throws MailboxException;

    public List<MessageRange> copyMessages(MessageRange var1, MailboxId var2, MailboxId var3, MailboxSession var4) throws MailboxException;

    public List<MessageRange> moveMessages(MessageRange var1, MailboxPath var2, MailboxPath var3, MailboxSession var4) throws MailboxException;

    public List<MailboxMetaData> search(MailboxQuery var1, MailboxSession var2) throws MailboxException;

    public List<MessageId> search(MultimailboxesSearchQuery var1, MailboxSession var2, long var3) throws MailboxException;

    public boolean mailboxExists(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public MailboxSession createSystemSession(String var1, Logger var2) throws BadCredentialsException, MailboxException;

    public MailboxSession login(String var1, String var2, Logger var3) throws BadCredentialsException, MailboxException;

    public MailboxSession loginAsOtherUser(String var1, String var2, String var3, Logger var4) throws BadCredentialsException, MailboxException;

    public void logout(MailboxSession var1, boolean var2) throws MailboxException;

    public boolean hasRight(MailboxPath var1, MailboxACL.MailboxACLRight var2, MailboxSession var3) throws MailboxException;

    public MailboxACL.MailboxACLRights myRights(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public MailboxACL.MailboxACLRights[] listRigths(MailboxPath var1, MailboxACL.MailboxACLEntryKey var2, MailboxSession var3) throws MailboxException;

    public void setRights(MailboxPath var1, MailboxACL.MailboxACLCommand var2, MailboxSession var3) throws MailboxException;

    public List<MailboxPath> list(MailboxSession var1) throws MailboxException;

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath var1, MailboxSession var2, Set<MailboxAnnotationKey> var3) throws MailboxException;

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath var1, MailboxSession var2, Set<MailboxAnnotationKey> var3) throws MailboxException;

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath var1, MailboxSession var2, Set<MailboxAnnotationKey> var3) throws MailboxException;

    public void updateAnnotations(MailboxPath var1, MailboxSession var2, List<MailboxAnnotation> var3) throws MailboxException, AnnotationException;

    public boolean hasChildren(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public static enum SearchCapabilities {
        MultimailboxSearch,
        Text;

    }

    public static enum MessageCapabilities {
        Attachment,
        UniqueID;

    }

    public static enum MailboxCapabilities {
        Annotation,
        Move,
        Namespace,
        UserFlag;

    }
}

