/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.library;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.mailet.HostAddress;
import org.slf4j.Logger;

public class MXHostAddressIterator
implements Iterator<HostAddress> {
    private final Iterator<HostAddress> addresses;

    public MXHostAddressIterator(Iterator<String> hosts, DNSService dns, boolean useSingleIP, Logger logger) {
        this(hosts, 25, dns, useSingleIP, logger);
    }

    public MXHostAddressIterator(Iterator<String> hosts, int defaultPort, DNSService dns, boolean useSingleIP, Logger logger) {
        Preconditions.checkNotNull(hosts, (Object)"Hosts is null");
        Preconditions.checkNotNull((Object)dns, (Object)"Dns is null");
        ArrayList hAddresses = Lists.newArrayList();
        while (hosts.hasNext()) {
            String nextHostname = hosts.next();
            Map.Entry<String, String> hostAndPort = MXHostAddressIterator.extractHostAndPort(nextHostname, defaultPort);
            try {
                Collection addrs = useSingleIP ? ImmutableList.of((Object)dns.getByName(hostAndPort.getKey())) : dns.getAllByName(hostAndPort.getKey());
                for (InetAddress addr : addrs) {
                    hAddresses.add(new HostAddress(hostAndPort.getKey(), "smtp://" + addr.getHostAddress() + ":" + hostAndPort.getValue()));
                }
            }
            catch (UnknownHostException uhe) {
                String logBuffer = "Couldn't resolve IP address for discovered host " + hostAndPort.getKey() + ".";
                logger.error(logBuffer);
            }
        }
        this.addresses = hAddresses.iterator();
    }

    private static Map.Entry<String, String> extractHostAndPort(String nextHostname, int defaultPort) {
        String hostname;
        String port;
        int idx = nextHostname.indexOf(58);
        if (idx > 0) {
            port = nextHostname.substring(idx + 1);
            hostname = nextHostname.substring(0, idx);
        } else {
            hostname = nextHostname;
            port = Integer.toString(defaultPort);
        }
        return Maps.immutableEntry((Object)hostname, (Object)port);
    }

    @Override
    public boolean hasNext() {
        return this.addresses.hasNext();
    }

    @Override
    public HostAddress next() {
        return this.addresses.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported by this iterator");
    }
}

