/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import com.google.common.base.Throwables;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.queue.activemq.FileSystemBlobTransferPolicy;

public class EmbeddedActiveMQ {
    private final ActiveMQConnectionFactory activeMQConnectionFactory;
    private final PersistenceAdapter persistenceAdapter;
    private BrokerService brokerService;

    @Inject
    private EmbeddedActiveMQ(FileSystem fileSystem, PersistenceAdapter persistenceAdapter) {
        this.persistenceAdapter = persistenceAdapter;
        try {
            this.launchEmbeddedBroker(fileSystem);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.activeMQConnectionFactory = this.createActiveMQConnectionFactory(this.createBlobTransferPolicy(fileSystem));
    }

    public ConnectionFactory getConnectionFactory() {
        return this.activeMQConnectionFactory;
    }

    @PreDestroy
    public void stop() throws Exception {
        this.brokerService.stop();
    }

    private ActiveMQConnectionFactory createActiveMQConnectionFactory(BlobTransferPolicy blobTransferPolicy) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://james?create=false");
        connectionFactory.setBlobTransferPolicy(blobTransferPolicy);
        connectionFactory.setPrefetchPolicy(this.createActiveMQPrefetchPolicy());
        return connectionFactory;
    }

    private ActiveMQPrefetchPolicy createActiveMQPrefetchPolicy() {
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(0);
        prefetchPolicy.setTopicPrefetch(0);
        return prefetchPolicy;
    }

    private BlobTransferPolicy createBlobTransferPolicy(FileSystem fileSystem) {
        FileSystemBlobTransferPolicy blobTransferPolicy = new FileSystemBlobTransferPolicy();
        blobTransferPolicy.setDefaultUploadUrl("file://var/store/activemq/blob-transfer");
        blobTransferPolicy.setFileSystem(fileSystem);
        return blobTransferPolicy;
    }

    private void launchEmbeddedBroker(FileSystem fileSystem) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setBrokerName("james");
        this.brokerService.setUseJmx(false);
        this.brokerService.setPersistent(true);
        this.brokerService.setDataDirectoryFile(fileSystem.getFile("file://var/store/activemq/brokers"));
        this.brokerService.setUseShutdownHook(false);
        this.brokerService.setSchedulerSupport(false);
        this.brokerService.setBrokerId("broker");
        String[] uris = new String[]{"tcp://localhost:0"};
        this.brokerService.setTransportConnectorURIs(uris);
        ManagementContext managementContext = new ManagementContext();
        managementContext.setCreateConnector(false);
        this.brokerService.setManagementContext(managementContext);
        this.brokerService.setPersistenceAdapter(this.persistenceAdapter);
        BrokerPlugin[] brokerPlugins = new BrokerPlugin[]{new StatisticsBrokerPlugin()};
        this.brokerService.setPlugins(brokerPlugins);
        String[] transportConnectorsURIs = new String[]{"tcp://localhost:0"};
        this.brokerService.setTransportConnectorURIs(transportConnectorsURIs);
        this.brokerService.start();
        System.out.println("Started : " + this.brokerService.isStarted());
    }
}

