/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.activemq.ActiveMQMailQueue;
import org.apache.james.queue.activemq.EmbeddedActiveMQ;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.JMSMailQueueFactory;

public class ActiveMQMailQueueFactory
extends JMSMailQueueFactory {
    private boolean useBlob = true;

    public ActiveMQMailQueueFactory(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MetricFactory metricFactory) {
        super(connectionFactory, mailQueueItemDecoratorFactory, metricFactory);
    }

    @Inject
    public ActiveMQMailQueueFactory(EmbeddedActiveMQ embeddedActiveMQ, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MetricFactory metricFactory) {
        this(embeddedActiveMQ.getConnectionFactory(), mailQueueItemDecoratorFactory, metricFactory);
    }

    public void setUseBlobMessages(boolean useBlob) {
        this.useBlob = useBlob;
    }

    protected MailQueue createMailQueue(String name) {
        return new ActiveMQMailQueue(this.connectionFactory, this.mailQueueItemDecoratorFactory, name, this.useBlob, this.metricFactory, this.log);
    }
}

