/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.BlobMessage;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageInputStream;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.activemq.ActiveMQMailQueueItem;
import org.apache.james.queue.activemq.ActiveMQSupport;
import org.apache.james.queue.activemq.MimeMessageBlobMessageSource;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.JMSMailQueue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;

public class ActiveMQMailQueue
extends JMSMailQueue
implements ActiveMQSupport {
    private final boolean useBlob;

    public ActiveMQMailQueue(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, String queuename, MetricFactory metricFactory, Logger logger) {
        this(connectionFactory, mailQueueItemDecoratorFactory, queuename, true, metricFactory, logger);
    }

    public ActiveMQMailQueue(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, String queuename, boolean useBlob, MetricFactory metricFactory, Logger logger) {
        super(connectionFactory, mailQueueItemDecoratorFactory, queuename, metricFactory, logger);
        this.useBlob = useBlob;
    }

    protected void populateMailMimeMessage(Message message, Mail mail) throws MessagingException, JMSException {
        if (message instanceof BlobMessage) {
            try {
                BlobMessage blobMessage = (BlobMessage)message;
                try {
                    mail.setAttribute("JAMES_BLOB_URL", (Serializable)blobMessage.getURL());
                    mail.setAttribute("JAMES_QUEUE_NAME", (Serializable)((Object)this.queueName));
                }
                catch (MalformedURLException e) {
                    this.logger.debug("Unable to get url from blobmessage for mail " + mail.getName());
                }
                MimeMessageBlobMessageSource source = new MimeMessageBlobMessageSource(blobMessage);
                mail.setMessage((MimeMessage)new MimeMessageCopyOnWriteProxy((MimeMessageSource)source));
            }
            catch (JMSException e) {
                throw new MailQueue.MailQueueException("Unable to populate MimeMessage for mail " + mail.getName(), (Exception)((Object)e));
            }
        }
        super.populateMailMimeMessage(message, mail);
    }

    protected void produceMail(Session session, Map<String, Object> props, int msgPrio, Mail mail) throws JMSException, MessagingException, IOException {
        MessageProducer producer = null;
        BlobMessage blobMessage = null;
        boolean reuse = false;
        try {
            if (this.useBlob) {
                ActiveMQSession amqSession = this.getAMQSession(session);
                if (blobMessage == null) {
                    blobMessage = amqSession.createBlobMessage((InputStream)new MimeMessageInputStream(mail.getMessage()));
                }
                props.put("JAMES_QUEUE_NAME", this.queueName);
                Queue queue = session.createQueue(this.queueName);
                producer = session.createProducer((Destination)queue);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    blobMessage.setObjectProperty(entry.getKey(), entry.getValue());
                }
                producer.send((Message)blobMessage, 2, msgPrio, 0L);
            } else {
                super.produceMail(session, props, msgPrio, mail);
            }
        }
        catch (JMSException e) {
            if (!reuse && blobMessage != null && blobMessage instanceof ActiveMQBlobMessage) {
                ((ActiveMQBlobMessage)blobMessage).deleteFile();
            }
            throw e;
        }
        finally {
            try {
                if (producer != null) {
                    producer.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }

    protected ActiveMQSession getAMQSession(Session session) {
        return (ActiveMQSession)session;
    }

    protected MailQueue.MailQueueItem createMailQueueItem(Connection connection, Session session, MessageConsumer consumer, Message message) throws JMSException, MessagingException {
        Mail mail = this.createMail(message);
        ActiveMQMailQueueItem activeMQMailQueueItem = new ActiveMQMailQueueItem(mail, connection, session, consumer, message, this.logger);
        return this.mailQueueItemDecoratorFactory.decorate((MailQueue.MailQueueItem)activeMQMailQueueItem);
    }

    public List<Message> removeWithSelector(String selector) throws MailQueue.MailQueueException {
        List mList = super.removeWithSelector(selector);
        for (Message m : mList) {
            if (!(m instanceof ActiveMQBlobMessage)) continue;
            try {
                ((ActiveMQBlobMessage)m).deleteFile();
            }
            catch (Exception e) {
                this.logger.error("Unable to delete blob file for message " + m, (Throwable)e);
            }
        }
        return mList;
    }

    protected Message copy(Session session, Message m) throws JMSException {
        if (m instanceof ActiveMQBlobMessage) {
            ActiveMQBlobMessage b = (ActiveMQBlobMessage)m;
            ActiveMQBlobMessage copy = (ActiveMQBlobMessage)this.getAMQSession(session).createBlobMessage(b.getURL());
            try {
                copy.setProperties(b.getProperties());
            }
            catch (IOException e) {
                throw JMSExceptionSupport.create((String)("Unable to copy message " + m), (Exception)e);
            }
            return copy;
        }
        return super.copy(session, m);
    }

    /*
     * Loose catch block
     */
    public long getSize() throws MailQueue.MailQueueException {
        block37: {
            Session session = null;
            MessageConsumer consumer = null;
            MessageProducer producer = null;
            TemporaryQueue replyTo = null;
            try {
                session = this.connection.createSession(false, 1);
                replyTo = session.createTemporaryQueue();
                consumer = session.createConsumer((Destination)replyTo);
                Queue myQueue = session.createQueue(this.queueName);
                producer = session.createProducer(null);
                String queueName = "ActiveMQ.Statistics.Destination." + myQueue.getQueueName();
                Queue query = session.createQueue(queueName);
                Message msg = session.createMessage();
                msg.setJMSReplyTo((Destination)replyTo);
                producer.send((Destination)query, msg);
                MapMessage reply = (MapMessage)consumer.receive(2000L);
                if (reply != null && reply.itemExists("size")) {
                    try {
                        long size;
                        long l = size = reply.getLong("size");
                        return l;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                break block37;
                {
                    catch (Exception e) {
                        throw new MailQueue.MailQueueException("Unable to remove mails", e);
                    }
                }
            }
            finally {
                if (consumer != null) {
                    try {
                        consumer.close();
                    }
                    catch (JMSException e1) {
                        e1.printStackTrace();
                    }
                }
                if (producer != null) {
                    try {
                        producer.close();
                    }
                    catch (JMSException jMSException) {}
                }
                if (replyTo != null) {
                    try {
                        replyTo.delete();
                    }
                    catch (JMSException jMSException) {}
                }
                try {
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException jMSException) {}
            }
        }
        return super.getSize();
    }
}

