/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieveserver.netty;

import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SessionTerminatedException;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.managesieve.util.SettableSession;
import org.apache.james.managesieveserver.netty.ChannelManageSieveResponseWriter;
import org.apache.james.protocols.api.logger.ProtocolLoggerAdapter;
import org.apache.james.protocols.api.logger.ProtocolSessionLogger;
import org.apache.james.protocols.lib.Slf4jLoggerAdapter;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelLocal;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;

public class ManageSieveChannelUpstreamHandler
extends SimpleChannelUpstreamHandler {
    static final String SSL_HANDLER = "sslHandler";
    private final Logger logger;
    private final ChannelLocal<Session> attributes;
    private final ManageSieveProcessor manageSieveProcessor;
    private final SSLContext sslContext;
    private final String[] enabledCipherSuites;
    private final boolean sslServer;

    public ManageSieveChannelUpstreamHandler(ManageSieveProcessor manageSieveProcessor, SSLContext sslContext, String[] enabledCipherSuites, boolean sslServer, Logger logger) {
        this.logger = logger;
        this.attributes = new ChannelLocal();
        this.manageSieveProcessor = manageSieveProcessor;
        this.sslContext = sslContext;
        this.enabledCipherSuites = enabledCipherSuites;
        this.sslServer = sslServer;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        String request = (String)e.getMessage();
        Session manageSieveSession = (Session)this.attributes.get(ctx.getChannel());
        String responseString = this.manageSieveProcessor.handleRequest(manageSieveSession, request);
        ((ChannelManageSieveResponseWriter)ctx.getAttachment()).write(responseString);
        if (manageSieveSession.getState() == Session.State.SSL_NEGOCIATION) {
            this.turnSSLon(ctx.getChannel());
            manageSieveSession.setSslEnabled(true);
            manageSieveSession.setState(Session.State.UNAUTHENTICATED);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.getLogger(ctx.getChannel()).warn("Error while processing ManageSieve request: " + e.getCause().getClass().getName() + " - " + e.getCause().getMessage());
        this.getLogger(ctx.getChannel()).debug("Error while processing ManageSieve request", e.getCause());
        if (e.getCause() instanceof TooLongFrameException) {
            ((ChannelManageSieveResponseWriter)ctx.getAttachment()).write("NO Maximum command line length exceeded");
        } else if (e.getCause() instanceof SessionTerminatedException) {
            ((ChannelManageSieveResponseWriter)ctx.getAttachment()).write("OK channel is closing");
            this.logout(ctx);
        }
    }

    private void logout(ChannelHandlerContext ctx) {
        this.attributes.remove(ctx.getChannel());
        Channel channel = ctx.getChannel();
        if (channel.isConnected()) {
            channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
        this.getLogger(ctx.getChannel()).info("Connection established from " + address.getAddress().getHostAddress());
        SettableSession session = new SettableSession();
        if (this.sslServer) {
            session.setSslEnabled(true);
        }
        this.attributes.set(ctx.getChannel(), (Object)session);
        ctx.setAttachment((Object)new ChannelManageSieveResponseWriter(ctx.getChannel()));
        super.channelBound(ctx, e);
        ((ChannelManageSieveResponseWriter)ctx.getAttachment()).write(this.manageSieveProcessor.getAdvertisedCapabilities());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
        this.getLogger(ctx.getChannel()).info("Connection closed for " + address.getAddress().getHostAddress());
        this.attributes.remove(ctx.getChannel());
        super.channelClosed(ctx, e);
    }

    private Logger getLogger(Channel channel) {
        return new Slf4jLoggerAdapter((org.apache.james.protocols.api.logger.Logger)new ProtocolSessionLogger("" + channel.getId(), (org.apache.james.protocols.api.logger.Logger)new ProtocolLoggerAdapter(this.logger)));
    }

    private void turnSSLon(Channel channel) {
        if (this.sslContext != null) {
            channel.setReadable(false);
            SslHandler filter = new SslHandler(this.sslContext.createSSLEngine(), false);
            filter.getEngine().setUseClientMode(false);
            if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
                filter.getEngine().setEnabledCipherSuites(this.enabledCipherSuites);
            }
            channel.getPipeline().addFirst(SSL_HANDLER, (ChannelHandler)filter);
            channel.setReadable(true);
        }
    }
}

