/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.utility.Base58;

public class PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathUtils.class);

    public static void recursiveDeleteDir(@NonNull Path directory) {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void mkdirp(Path directory) {
        boolean result = directory.toFile().mkdirs();
        if (!result) {
            throw new IllegalStateException("Failed to create directory at: " + directory);
        }
    }

    public static String createMinGWPath(String path) {
        String mingwPath = path.replace('\\', '/');
        int driveLetterIndex = 1;
        if (mingwPath.matches("^[a-zA-Z]:\\/.*")) {
            driveLetterIndex = 0;
        }
        mingwPath = "//" + Character.toLowerCase(mingwPath.charAt(driveLetterIndex)) + mingwPath.substring(driveLetterIndex + 1);
        mingwPath = mingwPath.replace(":", "");
        return mingwPath;
    }

    public static String extractClassPathResourceToTempLocation(String hostPath) {
        File tmpLocation = new File(".testcontainers-tmp-" + Base58.randomString(5));
        tmpLocation.delete();
        String jarPath = hostPath.replaceFirst("file:", "").replaceAll("!.*", "");
        String internalPath = hostPath.replaceAll("[^!]*!/", "");
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(internalPath)) continue;
                log.debug("Copying classpath resource(s) from {} to {} to permit Docker to bind", (Object)hostPath, (Object)tmpLocation);
                PathUtils.copyFromJarToLocation(jarFile, entry, internalPath, tmpLocation);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to process JAR file when extracting classpath resource: " + hostPath, e);
        }
        PathUtils.deleteOnExit(tmpLocation.toPath());
        return tmpLocation.getAbsolutePath();
    }

    private static void copyFromJarToLocation(JarFile jarFile, JarEntry entry, String fromRoot, File toRoot) throws IOException {
        String destinationName = entry.getName().replaceFirst(fromRoot, "");
        File newFile = new File(toRoot, destinationName);
        if (!entry.isDirectory()) {
            newFile.mkdirs();
            newFile.delete();
            newFile.deleteOnExit();
            try (InputStream is = jarFile.getInputStream(entry);){
                Files.copy(is, newFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                log.error("Failed to extract classpath resource " + entry.getName() + " from JAR file " + jarFile.getName(), (Throwable)e);
                throw e;
            }
        }
    }

    public static void deleteOnExit(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> PathUtils.recursiveDeleteDir(path)));
    }
}

