/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.apache.http.impl.client;

import java.security.Principal;
import javax.net.ssl.SSLSession;
import org.testcontainers.shaded.org.apache.http.HttpConnection;
import org.testcontainers.shaded.org.apache.http.annotation.Immutable;
import org.testcontainers.shaded.org.apache.http.auth.AuthScheme;
import org.testcontainers.shaded.org.apache.http.auth.AuthState;
import org.testcontainers.shaded.org.apache.http.auth.Credentials;
import org.testcontainers.shaded.org.apache.http.client.UserTokenHandler;
import org.testcontainers.shaded.org.apache.http.client.protocol.HttpClientContext;
import org.testcontainers.shaded.org.apache.http.conn.ManagedHttpClientConnection;
import org.testcontainers.shaded.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpConnection conn;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthState targetAuthState = clientContext.getTargetAuthState();
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = clientContext.getConnection()).isOpen() && conn instanceof ManagedHttpClientConnection && (sslsession = ((ManagedHttpClientConnection)conn).getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

