/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.netty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.testcontainers.shaded.com.github.dockerjava.netty.ChannelProvider;
import org.testcontainers.shaded.com.github.dockerjava.netty.InvocationBuilder;
import org.testcontainers.shaded.com.google.common.collect.ImmutableCollection;
import org.testcontainers.shaded.com.google.common.collect.ImmutableList;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public class WebTarget {
    private final ChannelProvider channelProvider;
    private final ImmutableList<String> path;
    private final ImmutableMap<String, String> queryParams;
    private static final String PATH_SEPARATOR = "/";

    public WebTarget(ChannelProvider channelProvider) {
        this(channelProvider, ImmutableList.of(), ImmutableMap.of());
    }

    private WebTarget(ChannelProvider channelProvider, ImmutableList<String> path, ImmutableMap<String, String> queryParams) {
        this.channelProvider = channelProvider;
        this.path = path;
        this.queryParams = queryParams;
    }

    public WebTarget path(String ... components) {
        ImmutableCollection.Builder newPath = ImmutableList.builder().addAll(this.path);
        for (String component : components) {
            ((ImmutableList.Builder)newPath).addAll(Arrays.asList(StringUtils.split((String)component, (String)PATH_SEPARATOR)));
        }
        return new WebTarget(this.channelProvider, (ImmutableList<String>)((ImmutableList.Builder)newPath).build(), this.queryParams);
    }

    public InvocationBuilder request() {
        String resource = PATH_SEPARATOR + StringUtils.join(this.path, (String)PATH_SEPARATOR);
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry entry : this.queryParams.entrySet()) {
            params.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        if (!params.isEmpty()) {
            resource = resource + "?" + StringUtils.join(params, (String)"&");
        }
        return new InvocationBuilder(this.channelProvider, resource);
    }

    public WebTarget resolveTemplate(String name, Object value) {
        ImmutableList.Builder newPath = ImmutableList.builder();
        for (String component : this.path) {
            component = component.replaceAll("\\{" + name + "\\}", value.toString());
            newPath.add(component);
        }
        return new WebTarget(this.channelProvider, (ImmutableList<String>)newPath.build(), this.queryParams);
    }

    public WebTarget queryParam(String name, Object value) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder().putAll(this.queryParams);
        if (value != null) {
            builder.put(name, value.toString());
        }
        return new WebTarget(this.channelProvider, this.path, builder.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebTarget webTarget = (WebTarget)o;
        if (this.channelProvider != null ? !this.channelProvider.equals(webTarget.channelProvider) : webTarget.channelProvider != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(webTarget.path) : webTarget.path != null) {
            return false;
        }
        return this.queryParams != null ? this.queryParams.equals(webTarget.queryParams) : webTarget.queryParams == null;
    }

    public int hashCode() {
        int result = this.channelProvider != null ? this.channelProvider.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.queryParams != null ? this.queryParams.hashCode() : 0);
        return result;
    }
}

