/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.jaxrs;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.testcontainers.shaded.com.github.dockerjava.jaxrs.ApacheUnixSocket;
import org.testcontainers.shaded.org.apache.http.HttpHost;
import org.testcontainers.shaded.org.apache.http.annotation.Contract;
import org.testcontainers.shaded.org.apache.http.annotation.ThreadingBehavior;
import org.testcontainers.shaded.org.apache.http.conn.ConnectTimeoutException;
import org.testcontainers.shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import org.testcontainers.shaded.org.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class UnixConnectionSocketFactory
implements ConnectionSocketFactory {
    private File socketFile;

    public UnixConnectionSocketFactory(URI socketUri) {
        String filename = socketUri.toString().replaceAll("^unix:///", "unix://localhost/").replaceAll("^unix://localhost", "");
        this.socketFile = new File(filename);
    }

    public static URI sanitizeUri(URI uri) {
        if (uri.getScheme().equals("unix")) {
            return URI.create("unix://localhost:80");
        }
        return uri;
    }

    @Override
    public Socket createSocket(HttpContext context) throws IOException {
        return new ApacheUnixSocket();
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        try {
            socket.connect((SocketAddress)new AFUNIXSocketAddress(this.socketFile), connectTimeout);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectTimeoutException(e, null, remoteAddress.getAddress());
        }
        return socket;
    }
}

