/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.jaxrs;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ListNetworksCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Network;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FiltersEncoder;
import org.testcontainers.shaded.com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import org.testcontainers.shaded.com.google.common.net.UrlEscapers;
import org.testcontainers.shaded.javax.ws.rs.client.WebTarget;
import org.testcontainers.shaded.javax.ws.rs.core.GenericType;

public class ListNetworksCmdExec
extends AbstrSyncDockerCmdExec<ListNetworksCmd, List<Network>>
implements ListNetworksCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListNetworksCmdExec.class);

    public ListNetworksCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Network> execute(ListNetworksCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/networks");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Network> networks = webTarget.request().accept("application/json").get(new GenericType<List<Network>>(){});
        LOGGER.trace("Response: {}", networks);
        return networks;
    }
}

