/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.profiler.Profiler;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.DockerClientException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Image;
import org.testcontainers.shaded.com.github.dockerjava.core.command.PullImageResultCallback;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.LazyFuture;

public class RemoteDockerImage
extends LazyFuture<String> {
    private static final Set<String> AVAILABLE_IMAGE_NAME_CACHE = new HashSet<String>();
    private final String dockerImageName;

    public RemoteDockerImage(String dockerImageName) {
        DockerImageName.validate(dockerImageName);
        this.dockerImageName = dockerImageName;
    }

    public RemoteDockerImage(@NonNull String repository, @NonNull String tag) {
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        if (tag == null) {
            throw new NullPointerException("tag");
        }
        this.dockerImageName = repository + ":" + tag;
    }

    @Override
    protected final String resolve() {
        Profiler profiler = new Profiler("Rule creation - prefetch image");
        Logger logger = DockerLoggerFactory.getLogger(this.dockerImageName);
        profiler.setLogger(logger);
        Profiler nested = profiler.startNested("Obtaining client");
        DockerClient dockerClient = DockerClientFactory.instance().client();
        try {
            nested.stop();
            profiler.start("Check local images");
            int attempts = 0;
            while (true) {
                if (AVAILABLE_IMAGE_NAME_CACHE.contains(this.dockerImageName)) {
                    logger.trace("{} is already in image name cache", (Object)this.dockerImageName);
                    break;
                }
                List updatedImages = (List)dockerClient.listImagesCmd().exec();
                for (Image image : updatedImages) {
                    if (image.getRepoTags() == null) continue;
                    Collections.addAll(AVAILABLE_IMAGE_NAME_CACHE, image.getRepoTags());
                }
                if (AVAILABLE_IMAGE_NAME_CACHE.contains(this.dockerImageName)) {
                    logger.trace("{} is in image name cache following listing of images", (Object)this.dockerImageName);
                    break;
                }
                if (attempts == 0) {
                    logger.info("Pulling docker image: {}. Please be patient; this may take some time but only needs to be done once.", (Object)this.dockerImageName);
                    profiler.start("Pull image");
                }
                if (attempts++ >= 3) {
                    logger.error("Retry limit reached while trying to pull image: " + this.dockerImageName + ". Please check output of `docker pull " + this.dockerImageName + "`");
                    throw new ContainerFetchException("Retry limit reached while trying to pull image: " + this.dockerImageName);
                }
                try {
                    dockerClient.pullImageCmd(this.dockerImageName).exec(new PullImageResultCallback()).awaitCompletion();
                }
                catch (InterruptedException e) {
                    throw new ContainerFetchException("Failed to fetch container image for " + this.dockerImageName, e);
                }
            }
            String string = this.dockerImageName;
            return string;
        }
        catch (DockerClientException e) {
            throw new ContainerFetchException("Failed to get Docker client for " + this.dockerImageName, e);
        }
        finally {
            profiler.stop().log();
        }
    }
}

