/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait;

import java.net.Socket;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.dockerclient.ProxiedUnixSocketClientProviderStrategy;

public class HostPortWaitStrategy
extends GenericContainer.AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(HostPortWaitStrategy.class);
    private static final String SUCCESS_MARKER = "TESTCONTAINERS_SUCCESS";

    @Override
    protected void waitUntilReady() {
        Callable<Boolean> checkStrategy;
        Integer port = this.getLivenessCheckPort();
        if (null == port) {
            log.debug("Liveness check port of {} is empty. Not waiting.", (Object)this.container.getContainerName());
            return;
        }
        if (DockerClientFactory.instance().isUsing(ProxiedUnixSocketClientProviderStrategy.class)) {
            List<Integer> exposedPorts = this.container.getExposedPorts();
            Integer exposedPort = exposedPorts.stream().filter(it -> port.equals(this.container.getMappedPort((int)it))).findFirst().orElse(null);
            if (null == exposedPort) {
                log.warn("Liveness check port of {} is set to {}, but it's not listed in exposed ports.", (Object)this.container.getContainerName(), (Object)port);
                return;
            }
            String[][] commands = new String[][]{{"/bin/sh", "-c", "nc -vz -w 1 localhost " + exposedPort + " && echo " + SUCCESS_MARKER}, {"/bin/bash", "-c", "</dev/tcp/localhost/" + exposedPort + " && echo " + SUCCESS_MARKER}};
            checkStrategy = () -> {
                for (String[] command : commands) {
                    try {
                        if (!this.container.execInContainer(command).getStdout().contains(SUCCESS_MARKER)) continue;
                        return true;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return false;
            };
        } else {
            checkStrategy = () -> {
                new Socket(this.container.getContainerIpAddress(), (int)port).close();
                return true;
            };
        }
        try {
            Unreliables.retryUntilTrue((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> (Boolean)this.getRateLimiter().getWhenReady(() -> {
                try {
                    return (Boolean)checkStrategy.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException("Timed out waiting for container port to open (" + this.container.getContainerIpAddress() + ":" + port + " should be listening)");
        }
    }
}

