/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.shaded.com.google.common.base.Splitter;
import org.testcontainers.shaded.com.google.common.collect.Maps;
import org.testcontainers.utility.CommandLine;
import org.testcontainers.utility.DockerLoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

class LocalDockerCompose
implements DockerCompose {
    private static final String COMPOSE_EXECUTABLE = "docker-compose";
    private final List<File> composeFiles;
    private final String identifier;
    private String cmd = "";
    private Map<String, String> env = new HashMap<String, String>();

    public LocalDockerCompose(List<File> composeFiles, String identifier) {
        this.validateFileList(composeFiles);
        this.composeFiles = composeFiles;
        this.identifier = identifier;
    }

    @Override
    public DockerCompose withCommand(String cmd) {
        this.cmd = cmd;
        return this;
    }

    @Override
    public DockerCompose withEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    @Override
    public void start() {
        if (!CommandLine.executableExists(COMPOSE_EXECUTABLE)) {
            throw new ContainerLaunchException("Local Docker Compose not found. Is docker-compose on the PATH?");
        }
        HashMap<String, String> environment = Maps.newHashMap(this.env);
        environment.put("COMPOSE_PROJECT_NAME", this.identifier);
        File dockerComposeBaseFile = this.composeFiles.get(0);
        File pwd = dockerComposeBaseFile.getAbsoluteFile().getParentFile().getAbsoluteFile();
        environment.put("COMPOSE_FILE", new File(pwd, dockerComposeBaseFile.getAbsoluteFile().getName()).getAbsolutePath());
        this.logger().info("Local Docker Compose is running command: {}", (Object)this.cmd);
        List<String> command = Splitter.onPattern(" ").omitEmptyStrings().splitToList("docker-compose " + this.cmd);
        try {
            new ProcessExecutor().command(command).redirectOutput((OutputStream)Slf4jStream.of((Logger)this.logger()).asInfo()).redirectError((OutputStream)Slf4jStream.of((Logger)this.logger()).asError()).environment(environment).directory(pwd).exitValueNormal().executeNoTimeout();
            this.logger().info("Docker Compose has finished running");
        }
        catch (InvalidExitValueException e) {
            throw new ContainerLaunchException("Local Docker Compose exited abnormally with code " + e.getExitValue() + " whilst running command: " + this.cmd);
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Error running local Docker Compose command: " + this.cmd, e);
        }
    }

    private Logger logger() {
        return DockerLoggerFactory.getLogger(COMPOSE_EXECUTABLE);
    }
}

