/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.jmx;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.lib.jmx.AbstractCommandHandlerStats;
import org.apache.james.smtpserver.jmx.SMTPCommandHandlerStatsMBean;

public class SMTPCommandHandlerStats
extends AbstractCommandHandlerStats
implements SMTPCommandHandlerStatsMBean,
Disposable {
    private final AtomicLong temp = new AtomicLong(0L);
    private final AtomicLong perm = new AtomicLong(0L);
    private final AtomicLong ok = new AtomicLong(0L);

    public SMTPCommandHandlerStats(String jmxPath, String handlerName, String[] commands) throws NotCompliantMBeanException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException {
        super(SMTPCommandHandlerStatsMBean.class, jmxPath, handlerName, commands);
    }

    @Override
    public long getTemporaryError() {
        return this.temp.get();
    }

    @Override
    public long getPermantError() {
        return this.perm.get();
    }

    @Override
    public long getOk() {
        return this.ok.get();
    }

    protected void incrementStats(Response response) {
        try {
            String code = response.getRetCode();
            char c = code.charAt(0);
            if (c == '5') {
                this.perm.incrementAndGet();
            } else if (c == '4') {
                this.temp.incrementAndGet();
            } else if (c == '2' || c == '3') {
                this.ok.incrementAndGet();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

