/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.jmx;

import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.smtpserver.jmx.HookStatsMBean;

public class HookStats
extends StandardMBean
implements HookStatsMBean,
Disposable {
    private final AtomicLong ok = new AtomicLong(0L);
    private final AtomicLong declined = new AtomicLong(0L);
    private final AtomicLong deny = new AtomicLong(0L);
    private final AtomicLong denysoft = new AtomicLong(0L);
    private final AtomicLong all = new AtomicLong(0L);
    private final String name;
    private final MBeanServer mbeanserver;
    private final String hookname;

    public HookStats(String jmxName, String hookname) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, NullPointerException {
        super(HookStatsMBean.class);
        this.hookname = hookname;
        this.name = "org.apache.james:type=server,name=" + jmxName + ",chain=handlerchain,handler=hook,hook=" + hookname;
        this.mbeanserver = ManagementFactory.getPlatformMBeanServer();
        ObjectName baseObjectName = new ObjectName(this.name);
        this.mbeanserver.registerMBean(this, baseObjectName);
    }

    public void increment(int code) {
        if ((code & 1) == 1) {
            this.ok.incrementAndGet();
        }
        if ((code & 8) == 8) {
            this.declined.incrementAndGet();
        }
        if ((code & 4) == 4) {
            this.denysoft.incrementAndGet();
        }
        if ((code & 2) == 2) {
            this.deny.incrementAndGet();
        }
        this.all.incrementAndGet();
    }

    @Override
    public long getOk() {
        return this.ok.get();
    }

    @Override
    public long getDeclined() {
        return this.declined.get();
    }

    @Override
    public long getDeny() {
        return this.deny.get();
    }

    @Override
    public long getDenysoft() {
        return this.denysoft.get();
    }

    public void dispose() {
        try {
            this.mbeanserver.unregisterMBean(new ObjectName(this.name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return this.hookname;
    }

    @Override
    public long getAll() {
        return this.all.get();
    }
}

