/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.AbstractValidRcptHandler;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class ValidRcptHandler
extends AbstractValidRcptHandler
implements ProtocolHandler {
    private UsersRepository users;
    private RecipientRewriteTable vut;
    private boolean useVut = true;
    private DomainList domains;

    public final UsersRepository getUsers() {
        return this.users;
    }

    @Inject
    public final void setUsersRepository(UsersRepository users) {
        this.users = users;
    }

    @Inject
    public final void setRecipientRewriteTable(RecipientRewriteTable vut) {
        this.vut = vut;
    }

    @Inject
    public void setDomainList(DomainList domains) {
        this.domains = domains;
    }

    public void setRecipientRewriteTableSupport(boolean useVut) {
        this.useVut = useVut;
    }

    protected boolean isValidRecipient(SMTPSession session, MailAddress recipient) {
        String username = recipient.toString();
        try {
            if (!this.users.supportVirtualHosting()) {
                username = recipient.getLocalPart();
            }
            if (this.users.contains(username)) {
                return true;
            }
            if (this.useVut) {
                session.getLogger().debug("Unknown user " + username + " check if its an alias");
                try {
                    Mappings targetString = this.vut.getMappings(recipient.getLocalPart(), recipient.getDomain());
                    if (targetString != null && !targetString.isEmpty()) {
                        return true;
                    }
                }
                catch (RecipientRewriteTable.ErrorMappingException e) {
                    return false;
                }
                catch (RecipientRewriteTableException e) {
                    session.getLogger().info("Unable to access RecipientRewriteTable", (Throwable)e);
                    return false;
                }
            }
            return false;
        }
        catch (UsersRepositoryException e) {
            session.getLogger().info("Unable to access UsersRepository", (Throwable)e);
            return false;
        }
    }

    protected boolean isLocalDomain(SMTPSession session, String domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            session.getLogger().error("Unable to get domains", (Throwable)e);
            return false;
        }
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setRecipientRewriteTableSupport(config.getBoolean("enableRecipientRewriteTable", true));
    }

    public void destroy() {
    }
}

