/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class UsersRepositoryAuthHook
implements AuthHook {
    private UsersRepository users;

    public final UsersRepository getUsers() {
        return this.users;
    }

    @Inject
    public final void setUsersRepository(UsersRepository users) {
        this.users = users;
    }

    public HookResult doAuth(SMTPSession session, String username, String password) {
        try {
            if (this.users.test(username, password)) {
                session.setUser(username);
                session.setRelayingAllowed(true);
                return new HookResult(1, "Authentication Successful");
            }
        }
        catch (UsersRepositoryException e) {
            session.getLogger().info("Unable to access UsersRepository", (Throwable)e);
        }
        return new HookResult(8);
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }
}

