/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;

public class SetMimeHeaderHandler
implements JamesMessageHook,
ProtocolHandler {
    private String headerName;
    private String headerValue;

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            if (this.headerName != null) {
                message.setHeader(this.headerName, this.headerValue);
                message.saveChanges();
            }
        }
        catch (MessagingException me) {
            session.getLogger().error(me.getMessage());
        }
        return new HookResult(8);
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setHeaderName(config.getString("headername"));
        this.setHeaderValue(config.getString("headervalue"));
    }

    public void destroy() {
    }
}

