/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractSenderAuthIdentifyVerificationRcptHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class SenderAuthIdentifyVerificationRcptHook
extends AbstractSenderAuthIdentifyVerificationRcptHook {
    private DomainList domains;
    private UsersRepository users;

    @Inject
    public final void setUsersRepository(UsersRepository users) {
        this.users = users;
    }

    @Inject
    public void setDomainList(DomainList domains) {
        this.domains = domains;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        ExtendedSMTPSession nSession = (ExtendedSMTPSession)session;
        if (nSession.verifyIdentity()) {
            return super.doRcpt(session, sender, rcpt);
        }
        return new HookResult(8);
    }

    protected boolean isLocalDomain(String domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            return false;
        }
    }

    protected boolean useVirtualHosting() {
        try {
            return this.users.supportVirtualHosting();
        }
        catch (UsersRepositoryException usersRepositoryException) {
            return false;
        }
    }
}

