/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.util.Collection;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;

public class SendMailHandler
implements JamesMessageHook {
    private MailQueue queue;
    private MailQueueFactory queueFactory;

    @Inject
    public void setMailQueueFactory(MailQueueFactory queueFactory) {
        this.queueFactory = queueFactory;
    }

    public void init(Configuration config) throws ConfigurationException {
        this.queue = this.queueFactory.getQueue("spool");
    }

    public void destroy() {
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        session.getLogger().debug("sending mail");
        try {
            this.queue.enQueue(mail);
            Collection theRecipients = mail.getRecipients();
            String recipientString = "";
            if (theRecipients != null) {
                recipientString = theRecipients.toString();
            }
            if (session.getLogger().isInfoEnabled()) {
                String infoBuffer = "Successfully spooled mail " + mail.getName() + " from " + mail.getSender() + " on " + session.getRemoteAddress().getAddress().toString() + " for " + recipientString;
                session.getLogger().info(infoBuffer.toString());
            }
        }
        catch (MessagingException me) {
            session.getLogger().error("Unknown error occurred while processing DATA.", (Throwable)me);
            return new HookResult(4, DSNStatus.getStatus((int)4, (String)"0.0") + " Error processing message.");
        }
        return new HookResult(1, DSNStatus.getStatus((int)2, (String)"6.0") + " Message received");
    }
}

