/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.io.Serializable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.core.MailImpl;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;

public class AddDefaultAttributesMessageHook
implements JamesMessageHook {
    private static final String SMTP_AUTH_NETWORK_NAME = "org.apache.james.SMTPIsAuthNetwork";

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        if (mail instanceof MailImpl) {
            MailImpl mailImpl = (MailImpl)mail;
            mailImpl.setRemoteHost(session.getRemoteAddress().getHostName());
            mailImpl.setRemoteAddr(session.getRemoteAddress().getAddress().getHostAddress());
            if (session.getUser() != null) {
                mail.setAttribute("org.apache.james.SMTPAuthUser", (Serializable)((Object)session.getUser()));
            }
            if (session.isRelayingAllowed()) {
                mail.setAttribute(SMTP_AUTH_NETWORK_NAME, (Serializable)((Object)"true"));
            }
        }
        return new HookResult(8);
    }
}

