/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.james.core.filesystem.Resource;
import org.apache.james.core.filesystem.ResourceUtils;

public class UrlResource
implements Resource {
    public static final String URL_PROTOCOL_FILE = "file";
    private final URL url;

    public UrlResource(URL url) {
        this.url = url;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        UrlResource.useCachesIfNecessary(con);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
    }

    @Override
    public File getFile() throws IOException {
        return ResourceUtils.getFile(this.url, "URL [" + this.url + "]");
    }
}

