/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.james.core.filesystem.Resource;
import org.apache.james.core.filesystem.ResourceUtils;
import org.apache.james.core.filesystem.SimpleUrl;

public class ClassPathResource
implements Resource {
    private final String path;
    private final ClassLoader classLoader;

    public ClassPathResource(String path) {
        this.path = this.sanitizePath(path);
        this.classLoader = this.getDefaultClassLoader();
    }

    private String sanitizePath(String path) {
        String pathToUse = new SimpleUrl(path).getSimplified();
        if (pathToUse.startsWith("/")) {
            return pathToUse.substring(1);
        }
        return pathToUse;
    }

    @Override
    public File getFile() throws IOException {
        URL url = this.getURL();
        return ResourceUtils.getFile(url, this.getDescription());
    }

    public URL getURL() throws IOException {
        URL url = this.resolveURL();
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    protected URL resolveURL() {
        return this.classLoader.getResource(this.path);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.classLoader.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return is;
    }

    public String getDescription() {
        return "class path resource [" + this.path + "]";
    }

    private ClassLoader getDefaultClassLoader() {
        ClassLoader currentThreadClassLoader = this.getcurrentThreadClassLoader();
        if (currentThreadClassLoader != null) {
            return currentThreadClassLoader;
        }
        ClassLoader currentClassClassLoader = ClassPathResource.class.getClassLoader();
        if (currentClassClassLoader != null) {
            return currentClassClassLoader;
        }
        return this.getSystemClassLoader();
    }

    private ClassLoader getcurrentThreadClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private ClassLoader getSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

