/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.UnsupportedDataTypeException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.InternetHeadersInputStream;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageWrapper;

public class MimeMessageUtil {
    public static void writeTo(MimeMessage message, OutputStream headerOs, OutputStream bodyOs) throws IOException, MessagingException {
        MimeMessageUtil.writeTo(message, headerOs, bodyOs, null);
    }

    public static void writeTo(MimeMessage message, OutputStream headerOs, OutputStream bodyOs, String[] ignoreList) throws IOException, MessagingException {
        MimeMessageWrapper wrapper;
        MimeMessage testMessage = message;
        if (message instanceof MimeMessageCopyOnWriteProxy) {
            MimeMessageCopyOnWriteProxy wr = (MimeMessageCopyOnWriteProxy)message;
            testMessage = wr.getWrappedMessage();
        }
        if (testMessage instanceof MimeMessageWrapper && !(wrapper = (MimeMessageWrapper)testMessage).isModified()) {
            wrapper.writeTo(headerOs, bodyOs, ignoreList);
            return;
        }
        MimeMessageUtil.writeToInternal(message, headerOs, bodyOs, ignoreList);
    }

    public static void writeToInternal(MimeMessage message, OutputStream headerOs, OutputStream bodyOs, String[] ignoreList) throws MessagingException, IOException {
        if (message.getMessageID() == null) {
            message.saveChanges();
        }
        MimeMessageUtil.writeHeadersTo(message, headerOs, ignoreList);
        MimeMessageUtil.writeMessageBodyTo(message, bodyOs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMessageBodyTo(MimeMessage message, OutputStream bodyOs) throws IOException, MessagingException {
        InputStream bis;
        OutputStream bos;
        try {
            bos = MimeUtility.encode((OutputStream)bodyOs, (String)message.getEncoding());
            bis = message.getInputStream();
        }
        catch (UnsupportedDataTypeException udte) {
            try {
                bis = message.getRawInputStream();
                bos = bodyOs;
            }
            catch (MessagingException _) {
                throw udte;
            }
        }
        catch (MessagingException me) {
            try {
                bis = message.getRawInputStream();
                bos = bodyOs;
            }
            catch (MessagingException _) {
                throw me;
            }
        }
        try {
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    private static void writeHeadersTo(MimeMessage message, OutputStream headerOs, String[] ignoreList) throws MessagingException {
        Enumeration headers = message.getNonMatchingHeaderLines(ignoreList);
        MimeMessageUtil.writeHeadersTo(headers, headerOs);
    }

    public static void writeHeadersTo(Enumeration<String> headers, OutputStream headerOs) throws MessagingException {
        try {
            IOUtils.copy((InputStream)new InternetHeadersInputStream(headers), (OutputStream)headerOs);
        }
        catch (IOException e) {
            throw new MessagingException("Unable to write headers to stream", (Exception)e);
        }
    }

    public static InputStream getHeadersInputStream(MimeMessage message, String[] ignoreList) throws MessagingException {
        return new InternetHeadersInputStream(message.getNonMatchingHeaderLines(ignoreList));
    }

    public static long getMessageSize(MimeMessage message) throws MessagingException {
        long size = -1L;
        if (message instanceof MimeMessageWrapper) {
            MimeMessageWrapper wrapper = (MimeMessageWrapper)message;
            size = wrapper.getMessageSize();
        } else if (message instanceof MimeMessageCopyOnWriteProxy) {
            MimeMessageCopyOnWriteProxy wrapper = (MimeMessageCopyOnWriteProxy)message;
            size = wrapper.getMessageSize();
        }
        if (size == -1L) {
            size = MimeMessageUtil.calculateMessageSize(message);
        }
        return size;
    }

    public static long calculateMessageSize(MimeMessage message) throws MessagingException {
        long size = message.getSize();
        if (size != -1L) {
            Enumeration e = message.getAllHeaderLines();
            if (e.hasMoreElements()) {
                size += 2L;
            }
            while (e.hasMoreElements()) {
                size += (long)(((String)e.nextElement()).length() + 2);
            }
        }
        if (size == -1L) {
            SizeCalculatorOutputStream out = new SizeCalculatorOutputStream();
            try {
                message.writeTo((OutputStream)out);
            }
            catch (IOException e) {
                throw new MessagingException("IOException wrapped by getMessageSize", (Exception)e);
            }
            size = out.getSize();
        }
        return size;
    }

    private static final class SizeCalculatorOutputStream
    extends OutputStream {
        long size = 0L;

        private SizeCalculatorOutputStream() {
        }

        @Override
        public void write(int arg0) throws IOException {
            ++this.size;
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public void write(byte[] arg0, int arg1, int arg2) throws IOException {
            this.size += (long)arg2;
        }

        @Override
        public void write(byte[] arg0) throws IOException {
            this.size += (long)arg0.length;
        }
    }
}

