/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.encode.base.ImapResponseComposerImpl;
import org.apache.james.imap.main.ResponseEncoder;
import org.apache.james.imapserver.netty.ChannelImapResponseWriter;
import org.apache.james.imapserver.netty.ImapHeartbeatHandler;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.NettyImapSession;
import org.apache.james.metrics.api.Metric;
import org.apache.james.protocols.api.logger.ProtocolLoggerAdapter;
import org.apache.james.protocols.api.logger.ProtocolSessionLogger;
import org.apache.james.protocols.lib.Slf4jLoggerAdapter;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.slf4j.Logger;

public class ImapChannelUpstreamHandler
extends SimpleChannelUpstreamHandler
implements NettyConstants {
    private final Logger logger;
    private final String hello;
    private final String[] enabledCipherSuites;
    private final SSLContext context;
    private final boolean compress;
    private final ImapProcessor processor;
    private final ImapEncoder encoder;
    private final ImapHeartbeatHandler heartbeatHandler = new ImapHeartbeatHandler();
    private final boolean plainAuthDisallowed;
    private final Metric imapConnectionsMetric;
    private final Metric imapCommandsMetric;

    public ImapChannelUpstreamHandler(String hello, ImapProcessor processor, ImapEncoder encoder, Logger logger, boolean compress, boolean plainAuthDisallowed, ImapMetrics imapMetrics) {
        this(hello, processor, encoder, logger, compress, plainAuthDisallowed, null, null, imapMetrics);
    }

    public ImapChannelUpstreamHandler(String hello, ImapProcessor processor, ImapEncoder encoder, Logger logger, boolean compress, boolean plainAuthDisallowed, SSLContext context, String[] enabledCipherSuites, ImapMetrics imapMetrics) {
        this.logger = logger;
        this.hello = hello;
        this.processor = processor;
        this.encoder = encoder;
        this.context = context;
        this.enabledCipherSuites = enabledCipherSuites;
        this.compress = compress;
        this.plainAuthDisallowed = plainAuthDisallowed;
        this.imapConnectionsMetric = imapMetrics.getConnectionsMetric();
        this.imapCommandsMetric = imapMetrics.getCommandsMetric();
    }

    private Logger getLogger(Channel channel) {
        return new Slf4jLoggerAdapter((org.apache.james.protocols.api.logger.Logger)new ProtocolSessionLogger("" + channel.getId(), (org.apache.james.protocols.api.logger.Logger)new ProtocolLoggerAdapter(this.logger)));
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        NettyImapSession imapsession = new NettyImapSession(ctx.getChannel(), this.logger, this.context, this.enabledCipherSuites, this.compress, this.plainAuthDisallowed);
        attributes.set(ctx.getChannel(), (Object)imapsession);
        super.channelBound(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
        this.getLogger(ctx.getChannel()).info("Connection closed for " + address.getAddress().getHostAddress());
        ImapSession imapSession = (ImapSession)attributes.remove(ctx.getChannel());
        if (imapSession != null) {
            imapSession.logout();
        }
        this.imapConnectionsMetric.decrement();
        super.channelClosed(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
        this.getLogger(ctx.getChannel()).info("Connection established from " + address.getAddress().getHostAddress());
        this.imapConnectionsMetric.increment();
        ImapResponseComposerImpl response = new ImapResponseComposerImpl((ImapResponseWriter)new ChannelImapResponseWriter(ctx.getChannel()));
        ctx.setAttachment((Object)response);
        response.untagged().message("OK").message(this.hello).end();
        super.channelConnected(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.getLogger(ctx.getChannel()).warn("Error while processing imap request: " + e.getCause().getClass().getName() + " - " + e.getCause().getMessage());
        this.getLogger(ctx.getChannel()).debug("Error while processing imap request", e.getCause());
        if (e.getCause() instanceof TooLongFrameException) {
            ImapResponseComposer composer = (ImapResponseComposer)ctx.getAttachment();
            composer.untaggedResponse("BAD failed. Maximum command line length exceeded");
        } else {
            Channel channel;
            ImapSession imapSession = (ImapSession)attributes.get(ctx.getChannel());
            if (imapSession != null) {
                imapSession.logout();
            }
            if ((channel = ctx.getChannel()).isConnected()) {
                channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.imapCommandsMetric.increment();
        ImapSession session = (ImapSession)attributes.get(ctx.getChannel());
        ImapResponseComposer response = (ImapResponseComposer)ctx.getAttachment();
        ImapMessage message = (ImapMessage)e.getMessage();
        ChannelPipeline cp = ctx.getPipeline();
        try {
            IOException failure;
            Channel channel;
            if (cp.get("executionHandler") != null) {
                cp.addBefore("executionHandler", "heartbeatHandler", (ChannelHandler)this.heartbeatHandler);
            } else {
                cp.addBefore("coreHandler", "heartbeatHandler", (ChannelHandler)this.heartbeatHandler);
            }
            ResponseEncoder responseEncoder = new ResponseEncoder(this.encoder, response, session);
            this.processor.process(message, (ImapProcessor.Responder)responseEncoder, session);
            if (session.getState() == ImapSessionState.LOGOUT && (channel = ctx.getChannel()).isConnected()) {
                channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            }
            if ((failure = responseEncoder.getFailure()) != null) {
                Logger logger = session.getLog();
                logger.info(failure.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to write " + message, (Throwable)failure);
                }
                throw failure;
            }
        }
        finally {
            ctx.getPipeline().remove("heartbeatHandler");
        }
        super.messageReceived(ctx, e);
    }
}

