/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.james.user.api.model.User;

public class ReadOnlyLDAPUser
implements User,
Serializable {
    private static final long serialVersionUID = -5201235065842464013L;
    private String _userName;
    private String _userDN;
    private LdapContext _ldapContext = null;

    private ReadOnlyLDAPUser() {
    }

    public ReadOnlyLDAPUser(String userName, String userDN, LdapContext ldapContext) {
        this();
        this._userName = userName;
        this._userDN = userDN;
        this._ldapContext = ldapContext;
    }

    public String getUserName() {
        return this._userName;
    }

    public boolean setPassword(String newPass) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyPassword(String password) {
        boolean result = false;
        LdapContext ldapContext = null;
        try {
            ldapContext = this._ldapContext.newInstance(null);
            ldapContext.addToEnvironment("java.naming.security.authentication", "simple");
            ldapContext.addToEnvironment("java.naming.security.principal", this._userDN);
            ldapContext.addToEnvironment("java.naming.security.credentials", password);
            ldapContext.reconnect(null);
            result = true;
        }
        catch (NamingException namingException) {
        }
        finally {
            if (null != ldapContext) {
                try {
                    ldapContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return result;
    }
}

