/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.StorageException;
import org.joda.time.DateTime;

public class SieveFileRepository
implements SieveRepository {
    private static final String SIEVE_ROOT = "file://sieve/";
    private static final String UTF_8 = "UTF-8";
    private static final String FILE_NAME_QUOTA = ".quota";
    private static final String FILE_NAME_ACTIVE = ".active";
    private static final List<String> SYSTEM_FILES = Arrays.asList(".quota", ".active");
    private static final int MAX_BUFF_SIZE = 32768;
    public static final String SIEVE_EXTENSION = ".sieve";
    private final FileSystem fileSystem;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String toString(File file, String encoding) throws FileNotFoundException {
        String script = null;
        Scanner scanner = null;
        try {
            scanner = new Scanner(file, encoding);
            scanner.useDelimiter("\\A");
            script = scanner.next();
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return script;
    }

    protected static void toFile(File file, String content) throws StorageException {
        int bufferSize = content.length() > 32768 ? 32768 : content.length();
        File tmpFile = null;
        OutputStreamWriter out = null;
        try {
            tmpFile = File.createTempFile(file.getName(), ".tmp", file.getParentFile());
            out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile), bufferSize), UTF_8);
            out.write(content);
        }
        catch (IOException ex) {
            try {
                FileUtils.deleteQuietly(tmpFile);
                throw new StorageException((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
        File backupFile = new File(file.getParentFile(), file.getName() + ".bak");
        if (file.exists()) {
            try {
                FileUtils.copyFile((File)file, (File)backupFile);
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
        try {
            FileUtils.copyFile((File)tmpFile, (File)file);
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
        if (tmpFile.exists()) {
            FileUtils.deleteQuietly((File)tmpFile);
        }
        if (backupFile.exists()) {
            FileUtils.deleteQuietly((File)backupFile);
        }
    }

    @Inject
    public SieveFileRepository(FileSystem fileSystem) throws IOException {
        this.fileSystem = fileSystem;
        File root = fileSystem.getFile(SIEVE_ROOT);
        FileUtils.forceMkdir((File)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteScript(String user, String name) throws ScriptNotFoundException, IsActiveException, StorageException {
        Object object = this.lock;
        synchronized (object) {
            File file = this.getScriptFile(user, name);
            if (this.isActiveFile(user, file)) {
                throw new IsActiveException("User: " + user + "Script: " + name);
            }
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public InputStream getScript(String user, String name) throws ScriptNotFoundException, StorageException {
        FileInputStream script;
        try {
            script = new FileInputStream(this.getScriptFile(user, name));
        }
        catch (FileNotFoundException ex) {
            throw new ScriptNotFoundException((Throwable)ex);
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void haveSpace(String user, String name, long size) throws QuotaExceededException, StorageException {
        long usedSpace = 0L;
        for (File file : this.getUserDirectory(user).listFiles()) {
            if (file.getName().equals(name) || SYSTEM_FILES.contains(file.getName())) continue;
            usedSpace += file.length();
        }
        long quota = Long.MAX_VALUE;
        File file = this.getQuotaFile(user);
        if (!file.exists()) {
            file = this.getQuotaFile();
        }
        if (file.exists()) {
            Scanner scanner = null;
            try {
                scanner = new Scanner(file, UTF_8);
                quota = scanner.nextLong();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            finally {
                if (null != scanner) {
                    scanner.close();
                }
            }
        }
        if (usedSpace + size > quota) {
            throw new QuotaExceededException(" Quota: " + quota + " Used: " + usedSpace + " Requested: " + size);
        }
    }

    public List<ScriptSummary> listScripts(String user) throws StorageException {
        File[] files = this.getUserDirectory(user).listFiles();
        ArrayList<ScriptSummary> summaries = new ArrayList<ScriptSummary>(files.length);
        File activeFile = null;
        try {
            activeFile = this.getActiveFile(user);
        }
        catch (ScriptNotFoundException scriptNotFoundException) {
            // empty catch block
        }
        for (File file : files) {
            if (SYSTEM_FILES.contains(file.getName())) continue;
            summaries.add(new ScriptSummary(file.getName(), this.isActive(file, activeFile)));
        }
        return summaries;
    }

    private boolean isActive(File file, File activeFile) {
        return null != activeFile && activeFile.equals(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putScript(String user, String name, String content) throws StorageException, QuotaExceededException {
        Object object = this.lock;
        synchronized (object) {
            File file = new File(this.getUserDirectory(user), name);
            this.haveSpace(user, name, content.length());
            SieveFileRepository.toFile(file, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameScript(String user, String oldName, String newName) throws ScriptNotFoundException, DuplicateException, StorageException {
        Object object = this.lock;
        synchronized (object) {
            File oldFile = this.getScriptFile(user, oldName);
            File newFile = new File(this.getUserDirectory(user), newName);
            if (newFile.exists()) {
                throw new DuplicateException("User: " + user + "Script: " + newName);
            }
            try {
                FileUtils.copyFile((File)oldFile, (File)newFile);
                if (this.isActiveFile(user, oldFile)) {
                    this.setActiveFile(newFile, user, true);
                }
                FileUtils.forceDelete((File)oldFile);
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public InputStream getActive(String user) throws ScriptNotFoundException, StorageException {
        FileInputStream script;
        try {
            script = new FileInputStream(this.getActiveFile(user));
        }
        catch (FileNotFoundException ex) {
            throw new ScriptNotFoundException((Throwable)ex);
        }
        return script;
    }

    public DateTime getActivationDateForActiveScript(String user) throws StorageException, ScriptNotFoundException {
        return new DateTime(this.getActiveFile(user).lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(String user, String name) throws ScriptNotFoundException, StorageException {
        Object object = this.lock;
        synchronized (object) {
            File oldActive = null;
            try {
                oldActive = this.getActiveFile(user);
                this.setActiveFile(oldActive, user, false);
            }
            catch (ScriptNotFoundException scriptNotFoundException) {
                // empty catch block
            }
            if (null != name && !name.trim().isEmpty()) {
                try {
                    this.setActiveFile(this.getScriptFile(user, name), user, true);
                }
                catch (ScriptNotFoundException ex) {
                    if (null != oldActive) {
                        this.setActiveFile(oldActive, user, true);
                    }
                    throw ex;
                }
            }
        }
    }

    protected File getSieveRootDirectory() throws StorageException {
        try {
            return this.fileSystem.getFile(SIEVE_ROOT);
        }
        catch (FileNotFoundException ex1) {
            throw new StorageException((Throwable)ex1);
        }
    }

    protected File getUserDirectory(String user) throws StorageException {
        File file = this.getUserDirectoryFile(user);
        if (!file.exists()) {
            this.ensureUser(user);
        }
        return file;
    }

    protected File getUserDirectoryFile(String user) throws StorageException {
        return new File(this.getSieveRootDirectory(), user + '/');
    }

    protected File getActiveFile(String user) throws ScriptNotFoundException, StorageException {
        String content;
        File dir = this.getUserDirectory(user);
        try {
            content = SieveFileRepository.toString(new File(dir, FILE_NAME_ACTIVE), UTF_8);
        }
        catch (FileNotFoundException ex) {
            throw new ScriptNotFoundException("There is no active script for user " + user);
        }
        return new File(dir, content);
    }

    protected boolean isActiveFile(String user, File file) throws StorageException {
        try {
            return 0 == this.getActiveFile(user).compareTo(file);
        }
        catch (ScriptNotFoundException ex) {
            return false;
        }
    }

    protected void setActiveFile(File scriptToBeActivated, String userName, boolean isActive) throws StorageException {
        File personalScriptDirectory = scriptToBeActivated.getParentFile();
        File sieveBaseDirectory = personalScriptDirectory.getParentFile();
        File activeScriptPersistenceFile = new File(personalScriptDirectory, FILE_NAME_ACTIVE);
        File activeScriptCopy = new File(sieveBaseDirectory, userName + SIEVE_EXTENSION);
        if (isActive) {
            SieveFileRepository.toFile(activeScriptPersistenceFile, scriptToBeActivated.getName());
            try {
                FileUtils.copyFile((File)scriptToBeActivated, (File)activeScriptCopy);
            }
            catch (IOException exception) {
                throw new StorageException("Can not copy active script to make it accessible for sieve utils", (Throwable)exception);
            }
        }
        try {
            FileUtils.forceDelete((File)activeScriptPersistenceFile);
            FileUtils.forceDelete((File)activeScriptCopy);
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    protected File getScriptFile(String user, String name) throws ScriptNotFoundException, StorageException {
        File file = new File(this.getUserDirectory(user), name);
        if (!file.exists()) {
            throw new ScriptNotFoundException("User: " + user + "Script: " + name);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureUser(String user) throws StorageException {
        Object object = this.lock;
        synchronized (object) {
            try {
                FileUtils.forceMkdir((File)this.getUserDirectoryFile(user));
            }
            catch (IOException e) {
                throw new StorageException("Error while creating directory for " + user, (Throwable)e);
            }
        }
    }

    protected File getQuotaFile() throws StorageException {
        return new File(this.getSieveRootDirectory(), FILE_NAME_QUOTA);
    }

    public boolean hasQuota() throws StorageException {
        return this.getQuotaFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQuota() throws QuotaNotFoundException, StorageException {
        Long quota = null;
        File file = this.getQuotaFile();
        if (file.exists()) {
            Scanner scanner = null;
            try {
                scanner = new Scanner(file, UTF_8);
                quota = scanner.nextLong();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            finally {
                if (null != scanner) {
                    scanner.close();
                }
            }
        }
        if (null == quota) {
            throw new QuotaNotFoundException("No default quota");
        }
        return quota;
    }

    public synchronized void removeQuota() throws QuotaNotFoundException, StorageException {
        File file = this.getQuotaFile();
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    public synchronized void setQuota(long quota) throws StorageException {
        File file = this.getQuotaFile();
        String content = Long.toString(quota);
        SieveFileRepository.toFile(file, content);
    }

    protected File getQuotaFile(String user) throws StorageException {
        return new File(this.getUserDirectory(user), FILE_NAME_QUOTA);
    }

    public boolean hasQuota(String user) throws StorageException {
        return this.getQuotaFile(user).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQuota(String user) throws QuotaNotFoundException, StorageException {
        Long quota = null;
        File file = this.getQuotaFile(user);
        if (file.exists()) {
            Scanner scanner = null;
            try {
                scanner = new Scanner(file, UTF_8);
                quota = scanner.nextLong();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            finally {
                if (null != scanner) {
                    scanner.close();
                }
            }
        }
        if (null == quota) {
            throw new QuotaNotFoundException("No quota for user: " + user);
        }
        return quota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuota(String user) throws QuotaNotFoundException, StorageException {
        Object object = this.lock;
        synchronized (object) {
            File file = this.getQuotaFile(user);
            if (!file.exists()) {
                return;
            }
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuota(String user, long quota) throws StorageException {
        Object object = this.lock;
        synchronized (object) {
            File file = this.getQuotaFile(user);
            String content = Long.toString(quota);
            SieveFileRepository.toFile(file, content);
        }
    }
}

