/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.file;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;

public class XMLRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private Map<String, String> mappings;

    protected void doConfigure(HierarchicalConfiguration arg0) throws ConfigurationException {
        String[] mapConf = arg0.getStringArray("mapping");
        this.mappings = Maps.newHashMap();
        if (mapConf != null && mapConf.length > 0) {
            for (String aMapConf : mapConf) {
                this.mappings.putAll(RecipientRewriteTableUtil.getXMLMappings((String)aMapConf));
            }
        } else {
            throw new ConfigurationException("No mapping configured");
        }
    }

    protected String mapAddressInternal(String user, String domain) throws RecipientRewriteTableException {
        if (this.mappings == null) {
            return null;
        }
        return RecipientRewriteTableUtil.getTargetString((String)user, (String)domain, this.mappings);
    }

    protected Mappings getUserDomainMappingsInternal(String user, String domain) throws RecipientRewriteTableException {
        if (this.mappings == null) {
            return null;
        }
        String maps = this.mappings.get(user + "@" + domain);
        if (maps != null) {
            return MappingsImpl.fromRawString((String)maps);
        }
        return null;
    }

    protected Map<String, Mappings> getAllMappingsInternal() throws RecipientRewriteTableException {
        if (this.mappings != null && this.mappings.size() > 0) {
            HashMap<String, Mappings> mappingsNew = new HashMap<String, Mappings>();
            for (String key : this.mappings.keySet()) {
                mappingsNew.put(key, (Mappings)MappingsImpl.fromRawString((String)this.mappings.get(key)));
            }
            return mappingsNew;
        }
        return null;
    }

    protected void addMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only implementation");
    }

    protected void removeMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only implementation");
    }
}

