/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.james.core.MailImpl;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.mailet.Mail;
import org.slf4j.Logger;

public class MBoxMailRepository
implements MailRepository,
LogEnabled,
Configurable {
    static final SimpleDateFormat dy = new SimpleDateFormat("EE MMM dd HH:mm:ss yyyy", Locale.US);
    static final String LOCKEXT = ".lock";
    static final String WORKEXT = ".work";
    static final int LOCKSLEEPDELAY = 2000;
    static final int MAXSLEEPTIMES = 100;
    static final long MLISTPRESIZEFACTOR = 10240L;
    static final long DEFAULTMLISTCAPACITY = 20L;
    private static boolean BUFFERING = true;
    private Hashtable<String, Long> mList = null;
    private String mboxFile;
    private boolean fifo;
    private Logger logger;

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        String checkType;
        this.mList = null;
        BUFFERING = configuration.getBoolean("[@BUFFERING]", true);
        this.fifo = configuration.getBoolean("[@FIFO]", false);
        String destination = configuration.getString("[@destinationURL]");
        this.mboxFile = destination.charAt(destination.length() - 1) == '/' ? destination.substring("mbox://".length(), destination.lastIndexOf("/")) : destination.substring("mbox://".length());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("MBoxMailRepository.destinationURL: " + destination);
        }
        if (!(checkType = configuration.getString("[@type]")).equals("MAIL") && !checkType.equals("SPOOL")) {
            String exceptionString = "Attempt to configure MboxMailRepository as " + checkType;
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(exceptionString);
            }
            throw new ConfigurationException(exceptionString);
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private String getRawMessage(MimeMessage mc) throws IOException, MessagingException {
        ByteArrayOutputStream rawMessage = new ByteArrayOutputStream();
        mc.writeTo((OutputStream)rawMessage);
        return rawMessage.toString();
    }

    private MimeMessage convertTextToMimeMessage(String emailBody) {
        MimeMessage mimeMessage = null;
        ByteArrayInputStream mb = new ByteArrayInputStream(emailBody.getBytes());
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props);
        try {
            mimeMessage = new MimeMessage(session, (InputStream)mb);
        }
        catch (MessagingException e) {
            this.getLogger().error("Unable to parse mime message!", (Throwable)e);
        }
        if (mimeMessage == null && this.getLogger().isDebugEnabled()) {
            String logBuffer = this.getClass().getName() + " Mime message is null";
            this.getLogger().debug(logBuffer);
        }
        return mimeMessage;
    }

    private String generateKeyValue(String emailBody) throws NoSuchAlgorithmException {
        byte[] digArray = MessageDigest.getInstance("MD5").digest(emailBody.getBytes());
        StringBuilder digest = new StringBuilder();
        for (byte aDigArray : digArray) {
            digest.append(Integer.toString(aDigArray, 36).toUpperCase(Locale.US));
        }
        return digest.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeMessage parseMboxFile(RandomAccessFile ins, MessageAction messAct) {
        if (this.getLogger().isDebugEnabled()) {
            String logBuffer = this.getClass().getName() + " Start parsing " + this.mboxFile;
            this.getLogger().debug(logBuffer);
        }
        try {
            MimeMessage endResult;
            CharSequence line;
            Pattern sepMatchPattern = Pattern.compile("^From (.*) (.*):(.*):(.*)$");
            boolean inMessage = false;
            StringBuffer messageBuffer = new StringBuffer();
            CharSequence previousMessageSeparator = null;
            long prevMessageStart = ins.getFilePointer();
            if (BUFFERING) {
                while ((line = ins.readLine()) != null) {
                    boolean foundSep = sepMatchPattern.matcher(line).matches();
                    if (foundSep && inMessage) {
                        endResult = messAct.messageAction((String)previousMessageSeparator, messageBuffer.toString(), prevMessageStart);
                        if (messAct.isComplete()) {
                            MimeMessage mimeMessage = endResult;
                            return mimeMessage;
                        }
                        previousMessageSeparator = line;
                        prevMessageStart = ins.getFilePointer() - (long)((String)line).length();
                        messageBuffer = new StringBuffer();
                        inMessage = true;
                    }
                    if (foundSep && !inMessage) {
                        previousMessageSeparator = line;
                        inMessage = true;
                    }
                    if (foundSep || !inMessage) continue;
                    messageBuffer.append((String)line).append("\n");
                }
            } else {
                int c;
                line = new StringBuffer();
                while ((c = ins.read()) != -1) {
                    if (c == 10) {
                        boolean foundSep = sepMatchPattern.matcher(line).matches();
                        if (foundSep && inMessage) {
                            endResult = messAct.messageAction((String)previousMessageSeparator, messageBuffer.toString(), prevMessageStart);
                            if (messAct.isComplete()) {
                                MimeMessage mimeMessage = endResult;
                                return mimeMessage;
                            }
                            previousMessageSeparator = ((StringBuffer)line).toString();
                            prevMessageStart = ins.getFilePointer() - (long)((StringBuffer)line).length();
                            messageBuffer = new StringBuffer();
                            inMessage = true;
                        }
                        if (foundSep && !inMessage) {
                            previousMessageSeparator = ((StringBuffer)line).toString();
                            inMessage = true;
                        }
                        if (!foundSep) {
                            messageBuffer.append((StringBuffer)line).append((char)c);
                        }
                        line = new StringBuffer();
                        continue;
                    }
                    ((StringBuffer)line).append((char)c);
                }
            }
            if (messageBuffer.length() != 0) {
                MimeMessage mimeMessage = messAct.messageAction((String)previousMessageSeparator, messageBuffer.toString(), prevMessageStart);
                return mimeMessage;
            }
        }
        catch (IOException ioEx) {
            this.getLogger().error("Unable to write file (General I/O problem) " + this.mboxFile, (Throwable)ioEx);
        }
        catch (PatternSyntaxException e) {
            this.getLogger().error("Bad regex passed " + this.mboxFile, (Throwable)e);
        }
        finally {
            if (this.getLogger().isDebugEnabled()) {
                String logBuffer = this.getClass().getName() + " Finished parsing " + this.mboxFile;
                this.getLogger().debug(logBuffer);
            }
        }
        return null;
    }

    private MimeMessage findMessage(String key) {
        MimeMessage foundMessage = this.selectMessage(key);
        if (foundMessage == null) {
            this.mList = null;
            this.loadKeys();
            foundMessage = this.selectMessage(key);
        }
        return foundMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeMessage selectMessage(final String key) {
        MimeMessage foundMessage = null;
        if (this.mList == null || !this.mList.containsKey(key)) {
            if (this.getLogger().isDebugEnabled()) {
                String logBuffer = this.getClass().getName() + " mList - key not found " + this.mboxFile;
                this.getLogger().debug(logBuffer);
            }
            return foundMessage;
        }
        long messageStart = this.mList.get(key);
        if (this.getLogger().isDebugEnabled()) {
            String logBuffer = this.getClass().getName() + " Load message starting at offset " + messageStart + " from file " + this.mboxFile;
            this.getLogger().debug(logBuffer);
        }
        RandomAccessFile ins = null;
        try {
            ins = new RandomAccessFile(this.mboxFile, "r");
            if (messageStart != 0L) {
                ins.seek(messageStart - 1L);
            }
            MessageAction op = new MessageAction(){

                @Override
                public boolean isComplete() {
                    return true;
                }

                @Override
                public MimeMessage messageAction(String messageSeparator, String bodyText, long messageStart) {
                    try {
                        if (key.equals(MBoxMailRepository.this.generateKeyValue(bodyText))) {
                            MBoxMailRepository.this.getLogger().debug(this.getClass().getName() + " Located message. Returning MIME message");
                            return MBoxMailRepository.this.convertTextToMimeMessage(bodyText);
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        MBoxMailRepository.this.getLogger().error("MD5 not supported! ", (Throwable)e);
                    }
                    return null;
                }
            };
            foundMessage = this.parseMboxFile(ins, op);
        }
        catch (FileNotFoundException e) {
            this.getLogger().error("Unable to save(open) file (File not found) " + this.mboxFile, (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to write file (General I/O problem) " + this.mboxFile, (Throwable)e);
        }
        finally {
            if (foundMessage == null && this.getLogger().isDebugEnabled()) {
                String logBuffer = this.getClass().getName() + " select - message not found " + this.mboxFile;
                this.getLogger().debug(logBuffer);
            }
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    this.getLogger().error("Unable to close file (General I/O problem) " + this.mboxFile, (Throwable)e);
                }
            }
        }
        return foundMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadKeys() {
        if (this.mList != null) {
            return;
        }
        RandomAccessFile ins = null;
        try {
            long initialCapacity;
            ins = new RandomAccessFile(this.mboxFile, "r");
            long l = initialCapacity = ins.length() > 10240L ? ins.length() / 10240L : 0L;
            if (initialCapacity < 20L) {
                initialCapacity = 20L;
            }
            if (initialCapacity > Integer.MAX_VALUE) {
                initialCapacity = 0x7FFFFFFEL;
            }
            this.mList = new Hashtable((int)initialCapacity);
            this.parseMboxFile(ins, new MessageAction(){

                @Override
                public boolean isComplete() {
                    return false;
                }

                @Override
                public MimeMessage messageAction(String messageSeparator, String bodyText, long messageStart) {
                    try {
                        String key = MBoxMailRepository.this.generateKeyValue(bodyText);
                        MBoxMailRepository.this.mList.put(key, messageStart);
                        if (MBoxMailRepository.this.getLogger().isDebugEnabled()) {
                            MBoxMailRepository.this.getLogger().debug(this.getClass().getName() + " Key " + key + " at " + messageStart);
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        MBoxMailRepository.this.getLogger().error("MD5 not supported! ", (Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (FileNotFoundException e) {
            this.getLogger().error("Unable to save(open) file (File not found) " + this.mboxFile, (Throwable)e);
            this.mList = new Hashtable(20);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to write file (General I/O problem) " + this.mboxFile, (Throwable)e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    this.getLogger().error("Unable to close file (General I/O problem) " + this.mboxFile, (Throwable)e);
                }
            }
        }
    }

    public void store(Mail mc) {
        if (this.getLogger().isDebugEnabled()) {
            String logBuffer = this.getClass().getName() + " Will store message to file " + this.mboxFile;
            this.getLogger().debug(logBuffer);
        }
        this.mList = null;
        String fromHeader = null;
        String message = null;
        try {
            message = this.getRawMessage(mc.getMessage());
            fromHeader = mc.getMessage().getFrom() == null ? "From   " + dy.format(Calendar.getInstance().getTime()) : "From " + mc.getMessage().getFrom()[0] + " " + dy.format(Calendar.getInstance().getTime());
        }
        catch (IOException e) {
            this.getLogger().error("Unable to parse mime message for " + this.mboxFile, (Throwable)e);
        }
        catch (MessagingException e) {
            this.getLogger().error("Unable to parse mime message for " + this.mboxFile, (Throwable)e);
        }
        try {
            RandomAccessFile saveFile = new RandomAccessFile(this.mboxFile, "rw");
            saveFile.seek(saveFile.length());
            saveFile.writeBytes(fromHeader + "\n");
            saveFile.writeBytes(message + "\n");
            saveFile.close();
        }
        catch (FileNotFoundException e) {
            this.getLogger().error("Unable to save(open) file (File not found) " + this.mboxFile, (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to write file (General I/O problem) " + this.mboxFile, (Throwable)e);
        }
    }

    public Iterator<String> list() {
        this.loadKeys();
        ArrayList<String> keys = new ArrayList<String>(this.mList.keySet());
        if (!keys.isEmpty()) {
            this.findMessage(keys.iterator().next());
        }
        if (this.getLogger().isDebugEnabled()) {
            String logBuffer = this.getClass().getName() + " " + keys.size() + " keys to be iterated over.";
            this.getLogger().debug(logBuffer);
        }
        if (this.fifo) {
            Collections.sort(keys);
        }
        return keys.iterator();
    }

    public Mail retrieve(String key) {
        this.loadKeys();
        MimeMessage foundMessage = this.findMessage(key);
        if (foundMessage == null) {
            this.getLogger().error("found message is null!");
            return null;
        }
        MailImpl res = new MailImpl();
        res.setMessage(foundMessage);
        res.setName(key);
        if (this.getLogger().isDebugEnabled()) {
            String logBuffer = this.getClass().getName() + " Retrieving entry for key " + key;
            this.getLogger().debug(logBuffer);
        }
        return res;
    }

    public void remove(Mail mail) {
        ArrayList<Mail> remArray = new ArrayList<Mail>();
        remArray.add(mail);
        this.remove(remArray);
    }

    private void lockMBox() throws Exception {
        String lockFileName = this.mboxFile + LOCKEXT;
        int sleepCount = 0;
        File mBoxLock = new File(lockFileName);
        if (!mBoxLock.createNewFile()) {
            while (!mBoxLock.createNewFile() && sleepCount < 100) {
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        String logBuffer = this.getClass().getName() + " Waiting for lock on file " + this.mboxFile;
                        this.getLogger().debug(logBuffer);
                    }
                    Thread.sleep(2000L);
                    ++sleepCount;
                }
                catch (InterruptedException e) {
                    this.getLogger().error("File lock wait for " + this.mboxFile + " interrupted!", (Throwable)e);
                }
            }
            if (sleepCount >= 100) {
                throw new Exception("Unable to get lock on file " + this.mboxFile);
            }
        }
    }

    private void unlockMBox() {
        String lockFileName = this.mboxFile + LOCKEXT;
        File mBoxLock = new File(lockFileName);
        try {
            FileUtils.forceDelete((File)mBoxLock);
        }
        catch (IOException e) {
            String logBuffer = this.getClass().getName() + " Failed to delete lock file " + lockFileName;
            this.getLogger().error(logBuffer);
        }
    }

    public void remove(final Collection<Mail> mails) {
        if (this.getLogger().isDebugEnabled()) {
            String logBuffer = this.getClass().getName() + " Removing entry for key " + mails;
            this.getLogger().debug(logBuffer);
        }
        try {
            RandomAccessFile ins = new RandomAccessFile(this.mboxFile, "r");
            final RandomAccessFile outputFile = new RandomAccessFile(this.mboxFile + WORKEXT, "rw");
            this.parseMboxFile(ins, new MessageAction(){

                @Override
                public boolean isComplete() {
                    return false;
                }

                @Override
                public MimeMessage messageAction(String messageSeparator, String bodyText, long messageStart) {
                    try {
                        String currentKey = MBoxMailRepository.this.generateKeyValue(bodyText);
                        boolean foundKey = false;
                        Iterator mailList = mails.iterator();
                        while (mailList.hasNext()) {
                            String key = ((Mail)mailList.next()).getName();
                            if (!key.equals(currentKey)) continue;
                            foundKey = true;
                            break;
                        }
                        if (!foundKey) {
                            outputFile.writeBytes(messageSeparator + "\n");
                            outputFile.writeBytes(bodyText);
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        MBoxMailRepository.this.getLogger().error("MD5 not supported! ", (Throwable)e);
                    }
                    catch (IOException e) {
                        MBoxMailRepository.this.getLogger().error("Unable to write file (General I/O problem) " + MBoxMailRepository.this.mboxFile, (Throwable)e);
                    }
                    return null;
                }
            });
            ins.close();
            outputFile.close();
            File mbox = new File(this.mboxFile);
            FileUtils.forceDelete((File)mbox);
            mbox = new File(this.mboxFile + WORKEXT);
            if (!mbox.renameTo(new File(this.mboxFile))) {
                throw new IOException("Failed to rename file " + mbox + " -> " + this.mboxFile);
            }
            Iterator<Mail> mailList = mails.iterator();
            while (mailList.hasNext()) {
                String key = mailList.next().getName();
                this.mList.remove(key);
            }
        }
        catch (FileNotFoundException e) {
            this.getLogger().error("Unable to save(open) file (File not found) " + this.mboxFile, (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to write file (General I/O problem) " + this.mboxFile, (Throwable)e);
        }
    }

    public void remove(String key) {
        this.loadKeys();
        try {
            this.lockMBox();
        }
        catch (Exception e) {
            this.getLogger().error("Lock failed!", (Throwable)e);
            return;
        }
        ArrayList<Mail> keys = new ArrayList<Mail>();
        keys.add(this.retrieve(key));
        this.remove(keys);
        this.unlockMBox();
    }

    public boolean lock(String key) {
        return false;
    }

    public boolean unlock(String key) {
        return false;
    }

    public static interface MessageAction {
        public boolean isComplete();

        public MimeMessage messageAction(String var1, String var2, long var3);
    }
}

