/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Singleton;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.lifecycle.api.Configurable;

@Singleton
public class XMLDomainList
extends AbstractDomainList
implements Configurable {
    private final List<String> domainNames = new ArrayList<String>();
    private boolean isConfigured = false;

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        super.configure(config);
        for (String serverNameConf : config.getStringArray("domainnames.domainname")) {
            try {
                this.addToServedDomains(serverNameConf);
            }
            catch (DomainListException e) {
                throw new ConfigurationException("Unable to add domain to memory", (Throwable)e);
            }
        }
        this.isConfigured = true;
    }

    protected List<String> getDomainListInternal() {
        return new ArrayList<String>(this.domainNames);
    }

    public boolean containsDomain(String domains) throws DomainListException {
        return this.domainNames.contains(domains.toLowerCase(Locale.US));
    }

    public void addDomain(String domain) throws DomainListException {
        if (this.isConfigured) {
            throw new DomainListException("Read-Only DomainList implementation");
        }
        this.domainNames.add(domain);
    }

    public void removeDomain(String domain) throws DomainListException {
        if (this.isConfigured) {
            throw new DomainListException("Read-Only DomainList implementation");
        }
        this.domainNames.remove(domain);
    }

    private void addToServedDomains(String domain) throws DomainListException {
        String newDomain = domain.toLowerCase(Locale.US);
        if (!this.containsDomain(newDomain)) {
            this.domainNames.add(newDomain);
        }
    }
}

