/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class Jdk8TypeModifier
extends TypeModifier {
    private static final Class<?>[] OPTIONAL_TYPES = new Class[]{OptionalInt.class, OptionalLong.class, OptionalDouble.class};
    private static final Class<?>[] OPTIONAL_TYPE_PARAMS = new Class[]{Integer.TYPE, Long.TYPE, Double.TYPE};

    public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
        Class raw = type.getRawClass();
        int len = OPTIONAL_TYPES.length;
        for (int i = 0; i < len; ++i) {
            if (raw != OPTIONAL_TYPES[i]) continue;
            return typeFactory.constructReferenceType(raw, typeFactory.constructType(OPTIONAL_TYPE_PARAMS[i]));
        }
        if (Optional.class.isAssignableFrom(raw)) {
            JavaType t;
            JavaType[] types = typeFactory.findTypeParameters(type, Optional.class);
            JavaType javaType = t = types == null || types.length == 0 ? null : types[0];
            if (t == null) {
                t = TypeFactory.unknownType();
            }
            return typeFactory.constructReferenceType(raw, t);
        }
        return type;
    }
}

