/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.util.CompletableFutureUtil;

public class FluentFutureStream<T> {
    private final CompletableFuture<Stream<T>> completableFuture;

    public static <T> FluentFutureStream<T> of(CompletableFuture<Stream<T>> completableFuture) {
        return new FluentFutureStream<T>(completableFuture);
    }

    public static <T> FluentFutureStream<T> of(Stream<CompletableFuture<T>> completableFutureStream) {
        return new FluentFutureStream<T>(CompletableFutureUtil.allOf(completableFutureStream));
    }

    @SafeVarargs
    public static <T> FluentFutureStream<T> ofFutures(CompletableFuture<T> ... completableFutures) {
        return new FluentFutureStream<T>(CompletableFutureUtil.allOfArray(completableFutures));
    }

    private FluentFutureStream(CompletableFuture<Stream<T>> completableFuture) {
        this.completableFuture = completableFuture;
    }

    public FluentFutureStream<T> performOnAll(Function<T, CompletableFuture<Void>> action) {
        return FluentFutureStream.of(CompletableFutureUtil.performOnAll(this.completableFuture(), action));
    }

    public <U> FluentFutureStream<U> map(Function<T, U> function) {
        return FluentFutureStream.of(CompletableFutureUtil.map(this.completableFuture(), function));
    }

    public CompletableFuture<Optional<T>> reduce(BinaryOperator<T> combiner) {
        return CompletableFutureUtil.reduce(combiner, this.completableFuture);
    }

    public CompletableFuture<T> reduce(T emptyAccumulator, BinaryOperator<T> combiner) {
        return CompletableFutureUtil.reduce(combiner, this.completableFuture, emptyAccumulator);
    }

    public <U> FluentFutureStream<U> thenComposeOnAll(Function<T, CompletableFuture<U>> function) {
        return FluentFutureStream.of(CompletableFutureUtil.thenComposeOnAll(this.completableFuture(), function));
    }

    public <U> FluentFutureStream<U> flatMap(Function<T, Stream<U>> function) {
        return FluentFutureStream.of(this.completableFuture().thenApply(stream -> stream.flatMap(function)));
    }

    public <U> FluentFutureStream<U> thenCompose(Function<Stream<T>, CompletableFuture<Stream<U>>> function) {
        return FluentFutureStream.of(this.completableFuture().thenCompose(function));
    }

    public CompletableFuture<Stream<T>> completableFuture() {
        return this.completableFuture;
    }

    public Stream<T> join() {
        return this.completableFuture().join();
    }
}

