/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.reflect;

import com.jayway.awaitility.reflect.FieldMatcherStrategy;
import com.jayway.awaitility.reflect.exception.FieldNotFoundException;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldTypeMatcherStrategy
extends FieldMatcherStrategy {
    final Class<?> expectedFieldType;

    public FieldTypeMatcherStrategy(Class<?> fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("field type cannot be null.");
        }
        this.expectedFieldType = fieldType;
    }

    @Override
    public boolean matches(Field field) {
        return this.expectedFieldType.equals(field.getType());
    }

    @Override
    public void notFound(Class<?> type, boolean isInstanceField) throws FieldNotFoundException {
        throw new FieldNotFoundException(String.format("No %s field of type \"%s\" could be found in the class hierarchy of %s.", isInstanceField ? "instance" : "static", this.expectedFieldType.getName(), type.getName()));
    }

    public String toString() {
        return "type " + this.expectedFieldType.getName();
    }
}

