/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.proxy;

import com.jayway.awaitility.proxy.CannotCreateProxyException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.objenesis.ObjenesisStd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyCreator {
    private ProxyCreator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object create(Class<? extends Object> targetClass, InvocationHandler invocationHandler) {
        Object proxy = null;
        if (!Modifier.isFinal(targetClass.getModifiers())) return ProxyCreator.createCGLibProxy(targetClass, invocationHandler);
        if (!ProxyCreator.targetClassHasInterfaces(targetClass)) throw new CannotCreateProxyException(String.format("Cannot create a proxy for class '%s' because it is final and doesn't implement any interfaces.", targetClass.getName()));
        return ProxyCreator.createInterfaceProxy(targetClass, invocationHandler);
    }

    private static Object createCGLibProxy(Class<? extends Object> targetClass, final InvocationHandler invocationHandler) {
        MethodInterceptor interceptor = new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                return invocationHandler.invoke(obj, method, args);
            }
        };
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(targetClass);
        enhancer.setCallbackType(interceptor.getClass());
        Class proxiedClass = enhancer.createClass();
        Enhancer.registerCallbacks((Class)proxiedClass, (Callback[])new Callback[]{interceptor});
        enhancer.setClassLoader(ProxyCreator.class.getClassLoader());
        ObjenesisStd objenesis = new ObjenesisStd();
        Object proxy = objenesis.newInstance(proxiedClass);
        return proxy;
    }

    private static Object createInterfaceProxy(Class<?> targetClass, InvocationHandler invocationHandler) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), ProxyCreator.getInterfaceHierarchy(targetClass), invocationHandler);
    }

    private static boolean targetClassHasInterfaces(Class<? extends Object> targetClass) {
        Class<?>[] interfaces = ProxyCreator.getInterfaceHierarchy(targetClass);
        return interfaces != null && interfaces.length >= 1;
    }

    private static Class<?>[] getInterfaceHierarchy(Class<? extends Object> targetClass) {
        if (targetClass == null || targetClass.equals(Object.class)) {
            return new Class[0];
        }
        HashSet interfaces = new HashSet();
        interfaces.addAll(Arrays.asList(targetClass.getInterfaces()));
        interfaces.addAll(Arrays.asList(ProxyCreator.getInterfaceHierarchy(targetClass.getSuperclass())));
        return interfaces.toArray(new Class[interfaces.size()]);
    }
}

