/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.core;

import com.jayway.awaitility.proxy.ProxyCreator;
import com.jayway.awaitility.proxy.TypeUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class MethodCallRecorder {
    private static final String NO_METHOD_CALL_RECORDED_MESSAGE = "No method call has been recorded. Perhaps the method was final?";
    private static ThreadLocal<Object> lastTarget = new ThreadLocal();
    private static ThreadLocal<Method> lastMethod = new ThreadLocal();
    private static ThreadLocal<Object[]> lastArgs = new ThreadLocal();
    private static InvocationHandler invocationHandler = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.shouldBeRecorded(method)) {
                lastMethod.set(method);
                lastArgs.set(args);
            }
            return TypeUtils.getDefaultValue(method.getReturnType());
        }

        private boolean shouldBeRecorded(Method method) {
            return !method.getDeclaringClass().equals(Object.class) || !method.getName().equals("finalize");
        }
    };

    public static Object createProxy(Object target) {
        Object proxy = ProxyCreator.create(target.getClass(), invocationHandler);
        lastTarget.set(target);
        return proxy;
    }

    public static Object getLastTarget() {
        Object target = lastTarget.get();
        if (target == null) {
            throw new IllegalStateException(NO_METHOD_CALL_RECORDED_MESSAGE);
        }
        return target;
    }

    public static Method getLastMethod() {
        Method method = lastMethod.get();
        if (method == null) {
            throw new IllegalStateException(NO_METHOD_CALL_RECORDED_MESSAGE);
        }
        return method;
    }

    public static Object[] getLastArgs() {
        Object target = lastTarget.get();
        if (target == null) {
            throw new IllegalStateException(NO_METHOD_CALL_RECORDED_MESSAGE);
        }
        return lastArgs.get();
    }

    public static void reset() {
        lastTarget.remove();
        lastMethod.remove();
        lastArgs.remove();
    }
}

