/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.core;

import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionEvaluationListener;
import com.jayway.awaitility.core.ExceptionIgnorer;

class ConditionSettings {
    private final String alias;
    private final Duration maxWaitTime;
    private final Duration pollInterval;
    private final Duration pollDelay;
    private final boolean catchUncaughtExceptions;
    private final ExceptionIgnorer ignoreExceptions;
    private final ConditionEvaluationListener conditionEvaluationListener;

    public ConditionSettings(String alias, boolean catchUncaughtExceptions, Duration maxWaitTime, Duration pollInterval, Duration pollDelay, ConditionEvaluationListener conditionEvaluationListener, ExceptionIgnorer ignoreExceptions) {
        if (maxWaitTime == null) {
            throw new IllegalArgumentException("You must specify a maximum waiting time (was null).");
        }
        if (pollInterval == null) {
            throw new IllegalArgumentException("You must specify a poll interval (was null).");
        }
        if (pollDelay == null) {
            throw new IllegalArgumentException("You must specify a poll delay (was null).");
        }
        this.alias = alias;
        this.maxWaitTime = maxWaitTime;
        this.pollInterval = pollInterval;
        this.pollDelay = pollDelay == Duration.SAME_AS_POLL_INTERVAL ? pollInterval : pollDelay;
        this.catchUncaughtExceptions = catchUncaughtExceptions;
        this.conditionEvaluationListener = conditionEvaluationListener;
        this.ignoreExceptions = ignoreExceptions;
    }

    public String getAlias() {
        return this.alias;
    }

    public Duration getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public Duration getPollDelay() {
        return this.pollDelay;
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public boolean shouldCatchUncaughtExceptions() {
        return this.catchUncaughtExceptions;
    }

    public ConditionEvaluationListener getConditionEvaluationListener() {
        return this.conditionEvaluationListener;
    }

    public boolean shouldExceptionBeIgnored(Exception e) {
        return this.ignoreExceptions.shouldIgnoreException(e);
    }
}

