/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.core;

import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.AssertionCondition;
import com.jayway.awaitility.core.CallableCondition;
import com.jayway.awaitility.core.CallableHamcrestCondition;
import com.jayway.awaitility.core.Condition;
import com.jayway.awaitility.core.ConditionEvaluationListener;
import com.jayway.awaitility.core.ConditionSettings;
import com.jayway.awaitility.core.ExceptionIgnorer;
import com.jayway.awaitility.core.HamcrestExceptionIgnorer;
import com.jayway.awaitility.core.MethodCallRecorder;
import com.jayway.awaitility.core.Predicate;
import com.jayway.awaitility.core.PredicateExceptionIgnorer;
import com.jayway.awaitility.core.ProxyHamcrestCondition;
import com.jayway.awaitility.core.SafeExceptionRethrower;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionFactory {
    private final Duration timeout;
    private final Duration pollInterval;
    private final boolean catchUncaughtExceptions;
    private final ExceptionIgnorer exceptionsIgnorer;
    private final String alias;
    private final Duration pollDelay;
    private final ConditionEvaluationListener conditionEvaluationListener;

    public ConditionFactory(String alias, Duration timeout, Duration pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer, ConditionEvaluationListener conditionEvaluationListener) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("pollInterval cannot be null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout cannot be null");
        }
        if (pollDelay == null) {
            throw new IllegalArgumentException("pollDelay cannot be null");
        }
        long timeoutInMS = timeout.getValueInMS();
        if (!timeout.isForever() && timeoutInMS <= pollInterval.getValueInMS()) {
            throw new IllegalStateException(String.format("Timeout (%s %s) must be greater than the poll interval (%s %s).", timeout.getValue(), timeout.getTimeUnitAsString(), pollInterval.getValue(), pollInterval.getTimeUnitAsString()));
        }
        if (!pollDelay.isForever() && !timeout.isForever() && timeoutInMS <= pollDelay.getValueInMS()) {
            throw new IllegalStateException(String.format("Timeout (%s %s) must be greater than the poll delay (%s %s).", timeout.getValue(), timeout.getTimeUnitAsString(), pollDelay.getValue(), pollDelay.getTimeUnitAsString()));
        }
        this.alias = alias;
        this.timeout = timeout;
        this.pollInterval = pollInterval;
        this.catchUncaughtExceptions = catchUncaughtExceptions;
        this.pollDelay = pollDelay;
        this.conditionEvaluationListener = conditionEvaluationListener;
        this.exceptionsIgnorer = exceptionsIgnorer;
    }

    public ConditionFactory(Duration timeout, Duration pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer) {
        this(null, timeout, pollInterval, pollDelay, catchUncaughtExceptions, exceptionsIgnorer, null);
    }

    public ConditionFactory(Duration timeout, Duration pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer, ConditionEvaluationListener conditionEvaluationListener) {
        this(null, timeout, pollInterval, pollDelay, catchUncaughtExceptions, exceptionsIgnorer, conditionEvaluationListener);
    }

    public ConditionFactory conditionEvaluationListener(ConditionEvaluationListener conditionEvaluationListener) {
        return new ConditionFactory(this.alias, this.timeout, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, conditionEvaluationListener);
    }

    public ConditionFactory timeout(Duration timeout) {
        return new ConditionFactory(this.alias, timeout, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory atMost(Duration timeout) {
        return new ConditionFactory(this.alias, timeout, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory forever() {
        return new ConditionFactory(this.alias, Duration.FOREVER, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory pollInterval(Duration pollInterval) {
        return new ConditionFactory(this.alias, this.timeout, pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory timeout(long timeout, TimeUnit unit) {
        return new ConditionFactory(this.alias, new Duration(timeout, unit), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory pollDelay(long delay, TimeUnit unit) {
        return new ConditionFactory(this.alias, this.timeout, this.pollInterval, new Duration(delay, unit), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory pollDelay(Duration pollDelay) {
        return new ConditionFactory(this.alias, this.timeout, this.pollInterval, pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory atMost(long timeout, TimeUnit unit) {
        return new ConditionFactory(this.alias, new Duration(timeout, unit), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory pollInterval(long pollInterval, TimeUnit unit) {
        return new ConditionFactory(this.alias, this.timeout, new Duration(pollInterval, unit), this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory catchUncaughtExceptions() {
        return new ConditionFactory(this.alias, this.timeout, this.pollInterval, this.pollDelay, true, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory ignoreExceptionsInstanceOf(final Class<? extends Exception> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("exceptionType cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeout, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return exceptionType.isAssignableFrom(e.getClass());
            }
        }), this.conditionEvaluationListener);
    }

    public ConditionFactory ignoreException(final Class<? extends Exception> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeout, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return e.getClass().equals(exceptionType);
            }
        }), this.conditionEvaluationListener);
    }

    public ConditionFactory ignoreExceptions() {
        return this.ignoreExceptionsMatching(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return true;
            }
        });
    }

    public ConditionFactory ignoreNoExceptions() {
        return this.ignoreExceptionsMatching(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return false;
            }
        });
    }

    public ConditionFactory ignoreExceptionsMatching(Matcher<? super Exception> matcher) {
        return new ConditionFactory(this.alias, this.timeout, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new HamcrestExceptionIgnorer(matcher), this.conditionEvaluationListener);
    }

    public ConditionFactory ignoreExceptionsMatching(Predicate<Exception> predicate) {
        return new ConditionFactory(this.alias, this.timeout, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer(predicate), this.conditionEvaluationListener);
    }

    public ConditionFactory await() {
        return this;
    }

    public ConditionFactory await(String alias) {
        return new ConditionFactory(alias, this.timeout, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener);
    }

    public ConditionFactory and() {
        return this;
    }

    public ConditionFactory with() {
        return this;
    }

    public ConditionFactory then() {
        return this;
    }

    public ConditionFactory given() {
        return this;
    }

    public ConditionFactory dontCatchUncaughtExceptions() {
        return new ConditionFactory(this.timeout, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer);
    }

    public <T> T untilCall(T ignore, Matcher<? super T> matcher) {
        MethodCaller supplier = new MethodCaller(MethodCallRecorder.getLastTarget(), MethodCallRecorder.getLastMethod(), MethodCallRecorder.getLastArgs());
        MethodCallRecorder.reset();
        ProxyHamcrestCondition<? super T> proxyCondition = new ProxyHamcrestCondition<T>(supplier, matcher, this.generateConditionSettings());
        return this.until(proxyCondition);
    }

    public <T> T until(Callable<T> supplier, Matcher<? super T> matcher) {
        return this.until(new CallableHamcrestCondition<T>(supplier, matcher, this.generateConditionSettings()));
    }

    public void until(Runnable supplier) {
        this.until(new AssertionCondition(supplier, this.generateConditionSettings()));
    }

    public Integer untilAtomic(final AtomicInteger atomic, Matcher<? super Integer> matcher) {
        return this.until(new CallableHamcrestCondition<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public Long untilAtomic(final AtomicLong atomic, Matcher<? super Long> matcher) {
        return this.until(new CallableHamcrestCondition<Long>(new Callable<Long>(){

            @Override
            public Long call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public void untilAtomic(final AtomicBoolean atomic, Matcher<? super Boolean> matcher) {
        this.until(new CallableHamcrestCondition<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public void untilTrue(AtomicBoolean atomic) {
        this.untilAtomic(atomic, (Matcher<? super Boolean>)Matchers.anyOf((Matcher)Matchers.is((Object)Boolean.TRUE), (Matcher)Matchers.is((Object)true)));
    }

    public void untilFalse(AtomicBoolean atomic) {
        this.untilAtomic(atomic, (Matcher<? super Boolean>)Matchers.anyOf((Matcher)Matchers.is((Object)Boolean.FALSE), (Matcher)Matchers.is((Object)false)));
    }

    public <V> V untilAtomic(final AtomicReference<V> atomic, Matcher<? super V> matcher) {
        return this.until(new CallableHamcrestCondition<V>(new Callable<V>(){

            @Override
            public V call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public <T> void until(Callable<Boolean> conditionEvaluator) {
        this.until(new CallableCondition(conditionEvaluator, this.generateConditionSettings()));
    }

    private ConditionSettings generateConditionSettings() {
        return new ConditionSettings(this.alias, this.catchUncaughtExceptions, this.timeout, this.pollInterval, this.pollDelay, this.conditionEvaluationListener, this.exceptionsIgnorer);
    }

    private <T> T until(Condition<T> condition) {
        return condition.await();
    }

    private static boolean isInstanceOf(Object object, String className) {
        try {
            object.getClass().isAssignableFrom(ConditionFactory.loadClass(className));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodCaller<T>
    implements Callable<T> {
        final Object target;
        final Method method;
        final Object[] args;

        public MethodCaller(Object target, Method method, Object[] args) {
            this.target = target;
            this.method = method;
            this.args = args;
            method.setAccessible(true);
        }

        @Override
        public T call() {
            try {
                return (T)this.method.invoke(this.target, this.args);
            }
            catch (IllegalAccessException e) {
                return SafeExceptionRethrower.safeRethrow(e);
            }
            catch (InvocationTargetException e) {
                return SafeExceptionRethrower.safeRethrow(e.getCause());
            }
        }
    }
}

