/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.core;

import com.jayway.awaitility.core.ConditionEvaluationListener;
import com.jayway.awaitility.core.EvaluatedCondition;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionEvaluationLogger
implements ConditionEvaluationListener<Object> {
    private final TimeUnit timeUnit;

    public ConditionEvaluationLogger() {
        this(TimeUnit.MILLISECONDS);
    }

    public ConditionEvaluationLogger(TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        this.timeUnit = timeUnit;
    }

    @Override
    public void conditionEvaluated(EvaluatedCondition<Object> condition) {
        String description = condition.getDescription();
        long elapsedTime = this.timeUnit.convert(condition.getElapsedTimeInMS(), TimeUnit.MILLISECONDS);
        long remainingTime = this.timeUnit.convert(condition.getRemainingTimeInMS(), TimeUnit.MILLISECONDS);
        String timeUnitAsString = this.timeUnit.toString().toLowerCase();
        if (condition.isSatisfied()) {
            System.out.printf("%s after %d %s (remaining time %d %s)\n", description, elapsedTime, timeUnitAsString, remainingTime, timeUnitAsString);
        } else {
            System.out.printf("%s (elapsed time %d %s, remaining time %d %s)\n", description, elapsedTime, timeUnitAsString, remainingTime, timeUnitAsString);
        }
    }
}

