/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.core;

import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionEvaluationListener;
import com.jayway.awaitility.core.ConditionSettings;
import com.jayway.awaitility.core.EvaluatedCondition;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConditionEvaluationHandler<T> {
    private final Matcher<? super T> matcher;
    private final ConditionSettings settings;
    private final StopWatch watch;

    public ConditionEvaluationHandler(Matcher<? super T> matcher, ConditionSettings settings) {
        this.matcher = matcher;
        this.settings = settings;
        this.watch = new StopWatch();
    }

    public void handleConditionResultMismatch(String mismatchMessage, T currentConditionValue) {
        ConditionEvaluationListener listener = this.settings.getConditionEvaluationListener();
        if (listener == null) {
            return;
        }
        long elapsedTimeInMS = this.watch.getElapsedTimeInMS();
        long remainingTimeInMS = this.getRemainingTimeInMS(elapsedTimeInMS, this.settings.getMaxWaitTime());
        try {
            listener.conditionEvaluated(new EvaluatedCondition<T>(mismatchMessage, this.matcher, currentConditionValue, elapsedTimeInMS, remainingTimeInMS, false, this.settings.getAlias()));
        }
        catch (ClassCastException e) {
            this.throwClassCastExceptionBecauseConditionEvaluationListenerCouldntBeApplied(e, listener);
        }
    }

    public void handleConditionResultMatch(String matchMessage, T currentConditionValue) {
        ConditionEvaluationListener listener = this.settings.getConditionEvaluationListener();
        if (listener == null) {
            return;
        }
        long elapsedTimeInMS = this.watch.getElapsedTimeInMS();
        long remainingTimeInMS = this.getRemainingTimeInMS(elapsedTimeInMS, this.settings.getMaxWaitTime());
        try {
            listener.conditionEvaluated(new EvaluatedCondition<T>(matchMessage, this.matcher, currentConditionValue, elapsedTimeInMS, remainingTimeInMS, true, this.settings.getAlias()));
        }
        catch (ClassCastException e) {
            this.throwClassCastExceptionBecauseConditionEvaluationListenerCouldntBeApplied(e, listener);
        }
    }

    private long getRemainingTimeInMS(long elapsedTimeInMS, Duration maxWaitTime) {
        return maxWaitTime.equals(Duration.FOREVER) ? Long.MAX_VALUE : maxWaitTime.getValueInMS() - elapsedTimeInMS;
    }

    private void throwClassCastExceptionBecauseConditionEvaluationListenerCouldntBeApplied(ClassCastException e, ConditionEvaluationListener listener) {
        throw new ClassCastException("Cannot apply condition evaluation listener " + listener.getClass().getName() + " because " + e.getMessage());
    }

    public void start() {
        this.watch.start();
    }

    private static class StopWatch {
        private long startTime;

        private StopWatch() {
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public long getElapsedTimeInMS() {
            return System.currentTimeMillis() - this.startTime;
        }
    }
}

