/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.core;

import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionSettings;
import com.jayway.awaitility.core.ConditionTimeoutException;
import com.jayway.awaitility.core.DeadlockException;
import com.jayway.awaitility.core.SafeExceptionRethrower;
import java.beans.Introspector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConditionAwaiter
implements Thread.UncaughtExceptionHandler {
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final CountDownLatch latch;
    private Throwable throwable = null;
    private final ConditionSettings conditionSettings;

    public ConditionAwaiter(final Callable<Boolean> condition, final ConditionSettings conditionSettings) {
        if (condition == null) {
            throw new IllegalArgumentException("You must specify a condition (was null).");
        }
        if (conditionSettings == null) {
            throw new IllegalArgumentException("You must specify the condition settings (was null).");
        }
        if (conditionSettings.shouldCatchUncaughtExceptions()) {
            Thread.setDefaultUncaughtExceptionHandler(this);
        }
        this.conditionSettings = conditionSettings;
        this.latch = new CountDownLatch(1);
        Runnable poller = new Runnable(){

            public void run() {
                block3: {
                    try {
                        if (((Boolean)condition.call()).booleanValue()) {
                            ConditionAwaiter.this.latch.countDown();
                        }
                    }
                    catch (Exception e) {
                        if (conditionSettings.shouldExceptionBeIgnored(e)) break block3;
                        ConditionAwaiter.this.throwable = e;
                        ConditionAwaiter.this.latch.countDown();
                    }
                }
            }
        };
        this.executor.scheduleWithFixedDelay(poller, conditionSettings.getPollDelay().getValueInMS(), conditionSettings.getPollInterval().getValueInMS(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() {
        block13: {
            try {
                try {
                    boolean finishedBeforeTimeout;
                    Duration maxWaitTime = this.conditionSettings.getMaxWaitTime();
                    long timeout = maxWaitTime.getValue();
                    if (maxWaitTime == Duration.FOREVER) {
                        this.latch.await();
                        finishedBeforeTimeout = true;
                    } else {
                        if (maxWaitTime == Duration.SAME_AS_POLL_INTERVAL) {
                            throw new IllegalStateException("Cannot use 'SAME_AS_POLL_INTERVAL' as maximum wait time.");
                        }
                        finishedBeforeTimeout = this.latch.await(timeout, maxWaitTime.getTimeUnit());
                    }
                    if (this.throwable != null) {
                        throw this.throwable;
                    }
                    if (finishedBeforeTimeout) break block13;
                    String maxWaitTimeLowerCase = maxWaitTime.getTimeUnitAsString();
                    String message = this.conditionSettings.hasAlias() ? String.format("Condition with alias '%s' didn't complete within %s %s because %s.", this.conditionSettings.getAlias(), timeout, maxWaitTimeLowerCase, Introspector.decapitalize(this.getTimeoutMessage())) : String.format("%s within %s %s.", this.getTimeoutMessage(), timeout, maxWaitTimeLowerCase);
                    ConditionTimeoutException e = new ConditionTimeoutException(message);
                    ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                    try {
                        long[] threadIds = bean.findDeadlockedThreads();
                        if (threadIds != null) {
                            e.initCause(new DeadlockException(threadIds));
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    throw e;
                }
                finally {
                    this.executor.shutdown();
                    if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        this.executor.shutdownNow();
                    }
                }
            }
            catch (Throwable e) {
                SafeExceptionRethrower.safeRethrow(e);
            }
        }
    }

    protected abstract String getTimeoutMessage();

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.throwable = throwable;
        if (this.latch.getCount() != 0L) {
            this.latch.countDown();
        }
    }
}

