/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.core;

import com.jayway.awaitility.core.Condition;
import com.jayway.awaitility.core.ConditionAwaiter;
import com.jayway.awaitility.core.ConditionEvaluationHandler;
import com.jayway.awaitility.core.ConditionSettings;
import com.jayway.awaitility.core.LambdaErrorMessageGenerator;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionCondition
implements Condition<Void> {
    private final ConditionAwaiter conditionAwaiter;
    private String lastExceptionMessage;
    private final ConditionEvaluationHandler<Object> conditionEvaluationHandler;

    public AssertionCondition(final Runnable supplier, final ConditionSettings settings) {
        if (supplier == null) {
            throw new IllegalArgumentException("You must specify a supplier (was null).");
        }
        this.conditionEvaluationHandler = new ConditionEvaluationHandler(null, settings);
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    supplier.run();
                    AssertionCondition.this.conditionEvaluationHandler.handleConditionResultMatch(AssertionCondition.this.getMatchMessage(supplier, settings.getAlias()), null);
                    return true;
                }
                catch (AssertionError e) {
                    AssertionCondition.this.lastExceptionMessage = ((Throwable)((Object)e)).getMessage();
                    AssertionCondition.this.conditionEvaluationHandler.handleConditionResultMismatch(AssertionCondition.this.getMismatchMessage(supplier, AssertionCondition.this.lastExceptionMessage, settings.getAlias()), null);
                    return false;
                }
            }
        };
        this.conditionAwaiter = new ConditionAwaiter(callable, settings){

            protected String getTimeoutMessage() {
                return AssertionCondition.this.getMismatchMessage(supplier, AssertionCondition.this.lastExceptionMessage, settings.getAlias());
            }
        };
    }

    private String getMatchMessage(Runnable supplier, String conditionAlias) {
        return this.generateDescriptionPrefix(supplier, conditionAlias) + " reached its end value";
    }

    private String getMismatchMessage(Runnable supplier, String exceptionMessage, String conditionAlias) {
        return this.generateDescriptionPrefix(supplier, conditionAlias) + " " + exceptionMessage;
    }

    private String generateDescriptionPrefix(Runnable supplier, String conditionAlias) {
        boolean hasAlias;
        String methodDescription = this.generateMethodDescription(supplier);
        boolean bl = hasAlias = conditionAlias != null;
        if (LambdaErrorMessageGenerator.isLambdaClass(supplier.getClass())) {
            String prefix = hasAlias ? "Condition with alias " + conditionAlias + " defined as a " : "Condition defined as a ";
            return prefix + LambdaErrorMessageGenerator.generateLambdaErrorMessagePrefix(supplier.getClass(), false) + methodDescription;
        }
        return "Runnable condition" + (hasAlias ? " with alias " + conditionAlias : "") + methodDescription;
    }

    private String generateMethodDescription(Runnable supplier) {
        String methodDescription = "";
        Method enclosingMethod = null;
        try {
            enclosingMethod = supplier.getClass().getEnclosingMethod();
        }
        catch (Error error) {
            // empty catch block
        }
        if (enclosingMethod != null) {
            methodDescription = " defined in " + enclosingMethod.toString();
        }
        return methodDescription;
    }

    @Override
    public Void await() {
        this.conditionEvaluationHandler.start();
        this.conditionAwaiter.await();
        return null;
    }
}

