/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility.core;

import com.jayway.awaitility.core.Condition;
import com.jayway.awaitility.core.ConditionAwaiter;
import com.jayway.awaitility.core.ConditionEvaluationHandler;
import com.jayway.awaitility.core.ConditionSettings;
import com.jayway.awaitility.core.HamcrestToStringFilter;
import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractHamcrestCondition<T>
implements Condition<T> {
    private ConditionAwaiter conditionAwaiter;
    private T lastResult;
    private final ConditionEvaluationHandler<T> conditionEvaluationHandler;

    public AbstractHamcrestCondition(final Callable<T> supplier, final Matcher<? super T> matcher, ConditionSettings settings) {
        if (supplier == null) {
            throw new IllegalArgumentException("You must specify a supplier (was null).");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("You must specify a matcher (was null).");
        }
        this.conditionEvaluationHandler = new ConditionEvaluationHandler<T>(matcher, settings);
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AbstractHamcrestCondition.this.lastResult = supplier.call();
                boolean matches = matcher.matches(AbstractHamcrestCondition.this.lastResult);
                if (matches) {
                    AbstractHamcrestCondition.this.conditionEvaluationHandler.handleConditionResultMatch(AbstractHamcrestCondition.this.getMatchMessage(supplier, matcher), AbstractHamcrestCondition.this.lastResult);
                } else {
                    AbstractHamcrestCondition.this.conditionEvaluationHandler.handleConditionResultMismatch(AbstractHamcrestCondition.this.getMismatchMessage(supplier, matcher), AbstractHamcrestCondition.this.lastResult);
                }
                return matches;
            }
        };
        this.conditionAwaiter = new ConditionAwaiter(callable, settings){

            protected String getTimeoutMessage() {
                return String.format("%s expected %s but was <%s>", AbstractHamcrestCondition.this.getCallableDescription(supplier), HamcrestToStringFilter.filter(matcher), AbstractHamcrestCondition.this.lastResult);
            }
        };
    }

    private String getMatchMessage(Callable<T> supplier, Matcher<? super T> matcher) {
        return String.format("%s reached its end value of %s", this.getCallableDescription(supplier), HamcrestToStringFilter.filter(matcher));
    }

    private String getMismatchMessage(Callable<T> supplier, Matcher<? super T> matcher) {
        StringDescription mismatchDescription = new StringDescription();
        matcher.describeMismatch(this.lastResult, (Description)mismatchDescription);
        return String.format("%s expected %s but %s", this.getCallableDescription(supplier), HamcrestToStringFilter.filter(matcher), mismatchDescription);
    }

    @Override
    public T await() {
        this.conditionEvaluationHandler.start();
        this.conditionAwaiter.await();
        return this.lastResult;
    }

    abstract String getCallableDescription(Callable<T> var1);
}

