/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility;

import java.util.concurrent.TimeUnit;

public class Duration {
    public static final Duration FOREVER = new Duration();
    public static final Duration ONE_HUNDRED_MILLISECONDS = new Duration(100L, TimeUnit.MILLISECONDS);
    public static final Duration TWO_HUNDRED_MILLISECONDS = new Duration(200L, TimeUnit.MILLISECONDS);
    public static final Duration FIVE_HUNDRED_MILLISECONDS = new Duration(500L, TimeUnit.MILLISECONDS);
    public static final Duration ONE_SECOND = new Duration(1L, TimeUnit.SECONDS);
    public static final Duration TWO_SECONDS = new Duration(2L, TimeUnit.SECONDS);
    public static final Duration FIVE_SECONDS = new Duration(5L, TimeUnit.SECONDS);
    public static final Duration TEN_SECONDS = new Duration(10L, TimeUnit.SECONDS);
    public static final Duration ONE_MINUTE = new Duration(60L, TimeUnit.SECONDS);
    public static final Duration TWO_MINUTES = new Duration(120L, TimeUnit.SECONDS);
    public static final Duration FIVE_MINUTES = new Duration(300L, TimeUnit.SECONDS);
    public static final Duration TEN_MINUTES = new Duration(600L, TimeUnit.SECONDS);
    public static final Duration SAME_AS_POLL_INTERVAL = new Duration();
    private static final int NONE = -1;
    private final long value;
    private final TimeUnit unit;

    private Duration() {
        this.value = -1L;
        this.unit = null;
    }

    public Duration(long value, TimeUnit unit) {
        if (value <= 0L) {
            throw new IllegalArgumentException("value must be > 0");
        }
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        this.value = value;
        this.unit = unit;
    }

    public TimeUnit getTimeUnit() {
        return this.unit;
    }

    public String getTimeUnitAsString() {
        return this.unit == null ? "<not defined>" : this.unit.toString().toLowerCase();
    }

    public boolean isForever() {
        return this.unit == null && this.value == -1L;
    }

    public long getValue() {
        return this.value;
    }

    public long getValueInMS() {
        if (this.value == -1L) {
            return this.value;
        }
        return TimeUnit.MILLISECONDS.convert(this.value, this.unit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.getValueInMS() == duration.getValueInMS();
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }
}

