/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.awaitility;

import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionEvaluationListener;
import com.jayway.awaitility.core.ConditionFactory;
import com.jayway.awaitility.core.ExceptionIgnorer;
import com.jayway.awaitility.core.FieldSupplierBuilder;
import com.jayway.awaitility.core.HamcrestExceptionIgnorer;
import com.jayway.awaitility.core.MethodCallRecorder;
import com.jayway.awaitility.core.Predicate;
import com.jayway.awaitility.core.PredicateExceptionIgnorer;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Awaitility {
    private static volatile Duration defaultPollInterval = Duration.ONE_HUNDRED_MILLISECONDS;
    private static volatile Duration defaultTimeout = Duration.TEN_SECONDS;
    private static volatile Duration defaultPollDelay = Duration.SAME_AS_POLL_INTERVAL;
    private static volatile boolean defaultCatchUncaughtExceptions = true;
    private static volatile ExceptionIgnorer defaultExceptionIgnorer = new PredicateExceptionIgnorer(new Predicate<Exception>(){

        @Override
        public boolean matches(Exception e) {
            return false;
        }
    });
    private static volatile ConditionEvaluationListener defaultConditionEvaluationListener = null;

    public static void catchUncaughtExceptionsByDefault() {
        defaultCatchUncaughtExceptions = true;
    }

    public static void doNotCatchUncaughtExceptionsByDefault() {
        defaultCatchUncaughtExceptions = false;
    }

    public static void ignoreExceptionsByDefault() {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return true;
            }
        });
    }

    public static void ignoreExceptionByDefault(final Class<? extends Exception> exceptionType) {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return e.getClass().equals(exceptionType);
            }
        });
    }

    public static void ignoreExceptionsByDefaultMatching(Predicate<Exception> predicate) {
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(predicate);
    }

    public static void ignoreExceptionsByDefaultMatching(Matcher<? super Exception> matcher) {
        defaultExceptionIgnorer = new HamcrestExceptionIgnorer(matcher);
    }

    public static void reset() {
        defaultPollInterval = Duration.ONE_HUNDRED_MILLISECONDS;
        defaultPollDelay = Duration.SAME_AS_POLL_INTERVAL;
        defaultTimeout = Duration.TEN_SECONDS;
        defaultCatchUncaughtExceptions = true;
        defaultConditionEvaluationListener = null;
        defaultExceptionIgnorer = new PredicateExceptionIgnorer(new Predicate<Exception>(){

            @Override
            public boolean matches(Exception e) {
                return false;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(null);
        MethodCallRecorder.reset();
    }

    public static ConditionFactory await() {
        return Awaitility.await(null);
    }

    public static ConditionFactory await(String alias) {
        return new ConditionFactory(alias, defaultTimeout, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener);
    }

    public static ConditionFactory catchUncaughtExceptions() {
        return new ConditionFactory(defaultTimeout, defaultPollInterval, defaultPollDelay, true, defaultExceptionIgnorer);
    }

    public static ConditionFactory dontCatchUncaughtExceptions() {
        return new ConditionFactory(defaultTimeout, defaultPollInterval, defaultPollDelay, false, defaultExceptionIgnorer);
    }

    public static ConditionFactory with() {
        return new ConditionFactory(defaultTimeout, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer, defaultConditionEvaluationListener);
    }

    public static ConditionFactory given() {
        return new ConditionFactory(defaultTimeout, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer);
    }

    public static ConditionFactory waitAtMost(Duration timeout) {
        return new ConditionFactory(timeout, defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer);
    }

    public static ConditionFactory waitAtMost(long value, TimeUnit unit) {
        return new ConditionFactory(new Duration(value, unit), defaultPollInterval, defaultPollDelay, defaultCatchUncaughtExceptions, defaultExceptionIgnorer);
    }

    public static void setDefaultPollInterval(long pollInterval, TimeUnit unit) {
        defaultPollInterval = new Duration(pollInterval, unit);
    }

    public static void setDefaultPollDelay(long pollDelay, TimeUnit unit) {
        defaultPollDelay = new Duration(pollDelay, unit);
    }

    public static void setDefaultTimeout(long timeout, TimeUnit unit) {
        defaultTimeout = new Duration(timeout, unit);
    }

    public static void setDefaultPollInterval(Duration pollInterval) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("You must specify a poll interval (was null).");
        }
        defaultPollInterval = pollInterval;
    }

    public static void setDefaultPollDelay(Duration pollDelay) {
        if (pollDelay == null) {
            throw new IllegalArgumentException("You must specify a poll delay (was null).");
        }
        defaultPollDelay = pollDelay;
    }

    public static void setDefaultTimeout(Duration defaultTimeout) {
        if (defaultTimeout == null) {
            throw new IllegalArgumentException("You must specify a default timeout (was null).");
        }
        Awaitility.defaultTimeout = defaultTimeout;
    }

    public static void setDefaultConditionEvaluationListener(ConditionEvaluationListener defaultConditionEvaluationListener) {
        Awaitility.defaultConditionEvaluationListener = defaultConditionEvaluationListener;
    }

    public static <S> S to(S object) {
        return (S)MethodCallRecorder.createProxy(object);
    }

    public static FieldSupplierBuilder fieldIn(Object object) {
        return new FieldSupplierBuilder(object);
    }

    public static FieldSupplierBuilder fieldIn(Class<?> clazz) {
        return new FieldSupplierBuilder(clazz);
    }
}

