/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.hook;

public final class HookResult {
    private static final HookResult DECLINED = new HookResult(8);
    private static final HookResult OK = new HookResult(1);
    private static final HookResult DENY = new HookResult(2);
    private static final HookResult DENYSOFT = new HookResult(4);
    private static final HookResult DISCONNECT = new HookResult(16);
    private final int result;
    private final String smtpRetCode;
    private final String smtpDescription;

    public HookResult(int result, String smtpRetCode, CharSequence smtpDescription) {
        boolean match = false;
        if ((result & 8) == 8) {
            if (match) {
                throw new IllegalArgumentException();
            }
            match = true;
        }
        if ((result & 1) == 1) {
            if (match) {
                throw new IllegalArgumentException();
            }
            match = true;
        }
        if ((result & 2) == 2) {
            if (match) {
                throw new IllegalArgumentException();
            }
            match = true;
        }
        if ((result & 4) == 4) {
            if (match) {
                throw new IllegalArgumentException();
            }
            match = true;
        }
        this.result = result;
        this.smtpRetCode = smtpRetCode;
        this.smtpDescription = smtpDescription == null ? null : smtpDescription.toString();
    }

    public HookResult(int result, String smtpDescription) {
        this(result, null, smtpDescription);
    }

    public HookResult(int result) {
        this(result, null, null);
    }

    public int getResult() {
        return this.result;
    }

    public String getSmtpRetCode() {
        return this.smtpRetCode;
    }

    public String getSmtpDescription() {
        return this.smtpDescription;
    }

    public static HookResult declined() {
        return DECLINED;
    }

    public static HookResult ok() {
        return OK;
    }

    public static HookResult deny() {
        return DENY;
    }

    public static HookResult denysoft() {
        return DENYSOFT;
    }

    public static HookResult disconnect() {
        return DISCONNECT;
    }
}

