/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.log;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;

public class HookResultLogger
implements HookResultHook {
    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    @Override
    public HookResult onHookResult(SMTPSession session, HookResult hResult, long executionTime, Hook hook) {
        boolean match = false;
        boolean info = false;
        int result = hResult.getResult();
        StringBuilder sb = new StringBuilder();
        sb.append(hook.getClass().getName());
        sb.append(": result=");
        sb.append(result);
        sb.append(" (");
        if ((result & 8) == 8) {
            sb.append("DECLINED");
            match = true;
        }
        if ((result & 1) == 1) {
            sb.append("OK");
            match = true;
        }
        if ((result & 2) == 2) {
            sb.append("DENY");
            match = true;
            info = true;
        }
        if ((result & 4) == 4) {
            sb.append("DENYSOFT");
            match = true;
            info = true;
        }
        if ((result & 0x10) == 16) {
            if (match) {
                sb.append("|");
            }
            sb.append("DISCONNECT");
            info = true;
        }
        sb.append(")");
        if (info) {
            session.getLogger().info(sb.toString());
        } else {
            session.getLogger().debug(sb.toString());
        }
        return hResult;
    }
}

